/*
 * Decompiled with CFR 0.152.
 */
package org.n3r.eql.eqler;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import org.n3r.eql.eqler.generators.ClassGenerator;
import org.n3r.eql.ex.EqlConfigException;

public class EqlerFactory {
    private static LoadingCache<Class, Object> eqlerCache = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<Class, Object>(){

        public Object load(Class eqlerClass) throws Exception {
            ClassGenerator generator = new ClassGenerator(eqlerClass);
            Class eqlImplClass = generator.generate();
            return EqlerFactory.createObject(eqlImplClass);
        }
    });

    public static <T> T getEqler(Class<T> eqlerClass) {
        EqlerFactory.ensureClassIsAnInterface(eqlerClass);
        return (T)eqlerCache.getUnchecked(eqlerClass);
    }

    private static <T> T createObject(Class<T> clazz) {
        return clazz.newInstance();
    }

    private static <T> void ensureClassIsAnInterface(Class<T> clazz) {
        if (clazz.isInterface()) {
            return;
        }
        throw new EqlConfigException(clazz + " is not an interface");
    }
}

