/*
 * Decompiled with CFR 0.152.
 */
package org.n3r.eql.eqler.generators;

import java.io.FileOutputStream;
import java.lang.reflect.Method;
import java.util.Collections;
import org.n3r.eql.eqler.annotations.EqlerConfig;
import org.n3r.eql.eqler.generators.EqlerClassLoader;
import org.n3r.eql.eqler.generators.MethodGenerator;
import org.n3r.eql.eqler.generators.TranableMethodGenerator;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;

public class ClassGenerator<T> {
    private final Class<T> eqlerClass;
    private final String implName;
    private final ClassWriter classWriter;

    public ClassGenerator(Class<T> eqlerClass) {
        this.eqlerClass = eqlerClass;
        this.implName = eqlerClass.getName() + "Impl";
        this.classWriter = this.createClassWriter();
    }

    public Class<? extends T> generate() {
        byte[] bytes = this.createEqlImplClassBytes();
        this.diagnose(bytes);
        return this.defineClass(bytes);
    }

    private void diagnose(byte[] bytes) {
        EqlerConfig eqlerConfig = this.eqlerClass.getAnnotation(EqlerConfig.class);
        if (eqlerConfig == null || !eqlerConfig.createClassFileForDiagnose()) {
            return;
        }
        this.writeClassFile4Diagnose(bytes, this.eqlerClass.getSimpleName() + "Impl.class");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeClassFile4Diagnose(byte[] bytes, String fileName) {
        FileOutputStream fos = new FileOutputStream(fileName);
        try {
            fos.write(bytes);
        }
        finally {
            if (Collections.singletonList(fos).get(0) != null) {
                fos.close();
            }
        }
    }

    private Class<? extends T> defineClass(byte[] bytes) {
        EqlerClassLoader loader = new EqlerClassLoader(this.eqlerClass.getClassLoader());
        return loader.defineClass(this.implName, bytes);
    }

    private byte[] createEqlImplClassBytes() {
        this.constructor();
        for (Method method : this.eqlerClass.getMethods()) {
            Object generator;
            if (TranableMethodGenerator.isEqlTranableMethod(method)) {
                generator = new TranableMethodGenerator<T>(this.classWriter, method, this.eqlerClass);
                ((TranableMethodGenerator)generator).generate();
                continue;
            }
            generator = new MethodGenerator<T>(this.classWriter, method, this.eqlerClass);
            ((MethodGenerator)generator).generate();
        }
        return this.createBytes();
    }

    private byte[] createBytes() {
        this.classWriter.visitEnd();
        return this.classWriter.toByteArray();
    }

    private ClassWriter createClassWriter() {
        String implSourceName = this.implName.replace('.', '/');
        ClassWriter cw = new ClassWriter(1);
        String[] interfaces = new String[]{Type.getInternalName(this.eqlerClass)};
        cw.visit(50, 33, implSourceName, null, "java/lang/Object", interfaces);
        return cw;
    }

    private void constructor() {
        MethodVisitor mv = this.classWriter.visitMethod(1, "<init>", "()V", null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(183, "java/lang/Object", "<init>", "()V", false);
        mv.visitInsn(177);
        mv.visitMaxs(1, 1);
        mv.visitEnd();
    }
}

