/*
 * Decompiled with CFR 0.152.
 */
package org.n3r.eql.matrix.sqlparser;

import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.expr.SQLBinaryOpExpr;
import com.alibaba.druid.sql.ast.expr.SQLBinaryOperator;
import com.alibaba.druid.sql.ast.expr.SQLIdentifierExpr;
import com.alibaba.druid.sql.ast.expr.SQLPropertyExpr;
import com.alibaba.druid.sql.ast.expr.SQLVariantRefExpr;
import com.alibaba.druid.sql.ast.statement.SQLExprTableSource;
import com.alibaba.druid.sql.ast.statement.SQLSelectItem;
import com.alibaba.druid.sql.ast.statement.SQLTableSource;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlSelectQueryBlock;
import com.alibaba.druid.sql.visitor.SQLASTVisitor;
import com.google.common.base.MoreObjects;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.n3r.eql.matrix.sqlparser.MysqlMatrixVisitor;
import org.n3r.eql.matrix.sqlparser.SqlFieldIndex;

public class MysqlSelectVisitor
extends MysqlMatrixVisitor {
    protected final Map<String, String> aliasTablesMap = Maps.newHashMap();
    protected SqlFieldIndex sqlFieldIndex;
    protected List<SqlFieldIndex> sqlFieldIndexeList;

    public boolean visit(MySqlSelectQueryBlock x) {
        for (SQLSelectItem item : x.getSelectList()) {
            item.accept((SQLASTVisitor)this);
        }
        if (x.getFrom() != null) {
            x.getFrom().accept((SQLASTVisitor)this);
        }
        this.acceptWhere(x.getWhere());
        return false;
    }

    protected void acceptWhere(SQLExpr where) {
        if (where != null) {
            this.sqlFieldIndexeList = Lists.newArrayList();
            where.accept((SQLASTVisitor)this);
            this.sqlFieldIndexes = this.sqlFieldIndexeList.toArray(new SqlFieldIndex[0]);
        }
    }

    public boolean visit(SQLBinaryOpExpr x) {
        if (x.getOperator() != SQLBinaryOperator.Equality) {
            return true;
        }
        if (this.hasSecuretField(x.getLeft()) && x.getRight() instanceof SQLVariantRefExpr || this.hasSecuretField(x.getRight()) && x.getLeft() instanceof SQLVariantRefExpr) {
            ++this.variantIndex;
            this.sqlFieldIndexeList.add(this.sqlFieldIndex);
        }
        return false;
    }

    private boolean hasSecuretField(SQLExpr field) {
        return field instanceof SQLIdentifierExpr && this.isSecuretField((SQLIdentifierExpr)field) || field instanceof SQLPropertyExpr && this.isSecuretField((SQLPropertyExpr)field);
    }

    private boolean isSecuretField(SQLIdentifierExpr field) {
        String oneTableName = this.getOneTableName();
        return oneTableName != null && this.containsInSecuretFields(oneTableName, field.getName());
    }

    private boolean isSecuretField(SQLPropertyExpr expr) {
        String tableName = this.aliasTablesMap.get(expr.getOwner().toString());
        String fieldName = expr.getName();
        return this.containsInSecuretFields(tableName, fieldName);
    }

    private boolean containsInSecuretFields(String tableName, String fieldName) {
        this.sqlFieldIndex = new SqlFieldIndex(tableName, fieldName, this.variantIndex);
        return this.ruleSet.relativeTo(tableName, fieldName);
    }

    private String getOneTableName() {
        Iterator<Map.Entry<String, String>> iterator;
        if (this.aliasTablesMap.size() == 1 && (iterator = this.aliasTablesMap.entrySet().iterator()).hasNext()) {
            Map.Entry<String, String> entry = iterator.next();
            return entry.getValue();
        }
        return null;
    }

    public boolean visit(SQLExprTableSource source) {
        if (source.getExpr() instanceof SQLIdentifierExpr) {
            this.addTableAlias((SQLTableSource)source, (SQLIdentifierExpr)source.getExpr());
        }
        return true;
    }

    private void addTableAlias(SQLTableSource from, SQLIdentifierExpr expr) {
        this.addTableAlias(from.getAlias(), expr);
    }

    private void addTableAlias(String alias, SQLIdentifierExpr expr) {
        this.addTableAlias(alias, expr.getName());
    }

    private void addTableAlias(String alias, String tableName) {
        this.aliasTablesMap.put((String)MoreObjects.firstNonNull((Object)alias, (Object)tableName), tableName);
    }
}

