/*
 * Decompiled with CFR 0.152.
 */
package org.n3r.eql.mtcp;

import com.codahale.metrics.Gauge;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Slf4jReporter;
import com.google.common.base.Preconditions;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.cache.RemovalListener;
import com.google.common.cache.RemovalNotification;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.sql.DataSource;
import org.n3r.eql.config.EqlConfig;
import org.n3r.eql.mtcp.DataSourceConfigurator;
import org.n3r.eql.mtcp.MtcpContext;
import org.n3r.eql.mtcp.TenantPropertiesConfigurator;
import org.n3r.eql.mtcp.utils.Mtcps;
import org.n3r.eql.util.S;
import org.slf4j.LoggerFactory;

public class MtcpDataSourceHandler
implements InvocationHandler {
    final TenantPropertiesConfigurator tenantPropertiesConfigurator;
    final EqlConfig eqlConfig;
    final ScheduledExecutorService destroyScheduler;
    final MetricRegistry metricsRegistry;
    final LoadingCache<String, DataSourceConfigurator> mtcpCache;

    public MtcpDataSourceHandler(EqlConfig eqlConfig) {
        this.eqlConfig = eqlConfig;
        this.tenantPropertiesConfigurator = this.createMtcpTenantPropertiesConfigurator(eqlConfig);
        this.mtcpCache = this.createMtcpCache(eqlConfig);
        this.destroyScheduler = Executors.newSingleThreadScheduledExecutor();
        this.destroyScheduler.scheduleWithFixedDelay(new Runnable(){

            @Override
            public void run() {
                MtcpDataSourceHandler.this.mtcpCache.cleanUp();
            }
        }, 600L, 600L, TimeUnit.SECONDS);
        this.metricsRegistry = new MetricRegistry();
        this.metricsRegistry.register(MetricRegistry.name((String)MtcpDataSourceHandler.class.getSimpleName(), (String[])new String[]{"cacheCount"}), (Metric)new Gauge<Long>(){

            public Long getValue() {
                return MtcpDataSourceHandler.this.mtcpCache.size();
            }
        });
        Slf4jReporter reporter = Slf4jReporter.forRegistry((MetricRegistry)this.metricsRegistry).outputTo(LoggerFactory.getLogger(MtcpDataSourceHandler.class)).convertRatesTo(TimeUnit.SECONDS).convertDurationsTo(TimeUnit.MILLISECONDS).build();
        reporter.start(1L, TimeUnit.MINUTES);
    }

    private LoadingCache<String, DataSourceConfigurator> createMtcpCache(EqlConfig eqlConfig) {
        String key = "mtcpCacheSpec";
        String mtcpCacheSpec = eqlConfig.getStr(key);
        Preconditions.checkNotNull((Object)mtcpCacheSpec, (String)"%s should not be empty!", (Object)key);
        return CacheBuilder.from((String)mtcpCacheSpec).removalListener((RemovalListener)new RemovalListener<String, DataSourceConfigurator>(){

            public void onRemoval(RemovalNotification<String, DataSourceConfigurator> notification) {
                String tenantId = (String)notification.getKey();
                DataSourceConfigurator dataSourceConfigurator = (DataSourceConfigurator)notification.getValue();
                dataSourceConfigurator.destory(tenantId, MtcpDataSourceHandler.this.metricsRegistry);
            }
        }).build((CacheLoader)new CacheLoader<String, DataSourceConfigurator>(){

            public DataSourceConfigurator load(String tenantId) throws Exception {
                return MtcpDataSourceHandler.this.createTenantDataSource(tenantId);
            }
        });
    }

    private TenantPropertiesConfigurator createMtcpTenantPropertiesConfigurator(EqlConfig eqlConfig) {
        String key = "tenantPropertiesConfigurator.spec";
        String impl = eqlConfig.getStr(key);
        Preconditions.checkNotNull((Object)impl, (String)"%s should not be empty!", (Object)key);
        return Mtcps.createObjectBySpec(impl, TenantPropertiesConfigurator.class);
    }

    private DataSource getTenantDataSource() {
        String tenantId = MtcpContext.getTenantId();
        Preconditions.checkNotNull((Object)tenantId, (Object)"there is no tenant id set in current thread local");
        return ((DataSourceConfigurator)this.mtcpCache.getUnchecked((Object)tenantId)).getDataSource();
    }

    private DataSourceConfigurator createTenantDataSource(String tenantId) {
        String key = "dataSourceConfigurator.spec";
        String impl = this.eqlConfig.getStr(key);
        if (S.isBlank(impl)) {
            impl = "@com.github.bingoohuang.mtcp.impl.DruidDataSourceConfigurator";
        }
        DataSourceConfigurator dataSourceConfigurator = Mtcps.createObjectBySpec(impl, DataSourceConfigurator.class);
        Map<String, String> props = Mtcps.merge(this.eqlConfig.params(), this.tenantPropertiesConfigurator.getTenantProperties(tenantId));
        dataSourceConfigurator.prepare(tenantId, props, this.metricsRegistry, this.destroyScheduler);
        return dataSourceConfigurator;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        return method.invoke((Object)this.getTenantDataSource(), args);
    }

    public DataSource newMtcpDataSource() {
        ClassLoader cl = this.getClass().getClassLoader();
        return (DataSource)Proxy.newProxyInstance(cl, new Class[]{DataSource.class}, (InvocationHandler)this);
    }
}

