/*
 * Decompiled with CFR 0.152.
 */
package org.n3r.eql.mtcp.impl;

import com.alibaba.druid.pool.DruidDataSource;
import com.codahale.metrics.Gauge;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import javax.sql.DataSource;
import org.n3r.eql.mtcp.DataSourceConfigurator;
import org.n3r.eql.util.O;
import org.n3r.eql.util.PropertyValueFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DruidDataSourceConfigurator
implements DataSourceConfigurator {
    private static final Logger log = LoggerFactory.getLogger(DruidDataSourceConfigurator.class);
    DruidDataSource druidDataSource = new DruidDataSource();

    @Override
    public void prepare(String tenantId, Map<String, String> props, MetricRegistry metricsRegistry, ScheduledExecutorService destroyScheduler) {
        this.createDruidDataSource(props, destroyScheduler);
        this.registerMetrics(tenantId, metricsRegistry);
    }

    private void createDruidDataSource(Map<String, String> props, ScheduledExecutorService destroyScheduler) {
        O.populate(this.druidDataSource, props, new PropertyValueFilter[0]);
        this.druidDataSource.setDestroyScheduler(destroyScheduler);
    }

    @Override
    public DataSource getDataSource() {
        return this.druidDataSource;
    }

    public void registerMetrics(String tenantId, MetricRegistry metricsRegistry) {
        String simpleName = DruidDataSource.class.getSimpleName();
        Gauge<Long> connectCount = new Gauge<Long>(){

            public Long getValue() {
                return DruidDataSourceConfigurator.this.druidDataSource.getConnectCount();
            }
        };
        metricsRegistry.register(MetricRegistry.name((String)simpleName, (String[])new String[]{tenantId, "connectCount"}), (Metric)connectCount);
        Gauge<Long> destroyCount = new Gauge<Long>(){

            public Long getValue() {
                return DruidDataSourceConfigurator.this.druidDataSource.getDestroyCount();
            }
        };
        metricsRegistry.register(MetricRegistry.name((String)simpleName, (String[])new String[]{tenantId, "destroyCount"}), (Metric)destroyCount);
        Gauge<Integer> activeCount = new Gauge<Integer>(){

            public Integer getValue() {
                return DruidDataSourceConfigurator.this.druidDataSource.getActiveCount();
            }
        };
        metricsRegistry.register(MetricRegistry.name((String)simpleName, (String[])new String[]{tenantId, "activeCount"}), (Metric)activeCount);
        Gauge<Integer> poolingCount = new Gauge<Integer>(){

            public Integer getValue() {
                return DruidDataSourceConfigurator.this.druidDataSource.getPoolingCount();
            }
        };
        metricsRegistry.register(MetricRegistry.name((String)simpleName, (String[])new String[]{tenantId, "poolingCount"}), (Metric)poolingCount);
    }

    @Override
    public void destory(String tenantId, MetricRegistry metricsRegistry) {
        this.unregisterMetrics(tenantId, metricsRegistry);
        this.destoryDatasource();
    }

    private void destoryDatasource() {
        try {
            this.druidDataSource.close();
            this.druidDataSource = null;
        }
        catch (Exception e) {
            log.error("close druidDataSource error", (Throwable)e);
        }
    }

    private void unregisterMetrics(String tenantId, MetricRegistry metricsRegistry) {
        String simpleName = DruidDataSource.class.getSimpleName();
        metricsRegistry.remove(MetricRegistry.name((String)simpleName, (String[])new String[]{tenantId, "connectCount"}));
        metricsRegistry.remove(MetricRegistry.name((String)simpleName, (String[])new String[]{tenantId, "destroyCount"}));
        metricsRegistry.remove(MetricRegistry.name((String)simpleName, (String[])new String[]{tenantId, "activeCount"}));
        metricsRegistry.remove(MetricRegistry.name((String)simpleName, (String[])new String[]{tenantId, "poolingCount"}));
    }
}

