/*
 * Decompiled with CFR 0.152.
 */
package org.n3r.eql.parser;

import java.util.List;
import java.util.regex.Matcher;
import org.n3r.eql.parser.EqlPart;
import org.n3r.eql.parser.LiteralPart;
import org.n3r.eql.parser.MultiPart;
import org.n3r.eql.parser.ParserUtils;
import org.n3r.eql.parser.PartParser;
import org.n3r.eql.parser.PartParserFactory;
import org.n3r.eql.parser.UnlessPart;

public class UnlessParser
implements PartParser {
    private String expr;
    private MultiPart multiPart = new MultiPart();

    public UnlessParser(String expr) {
        this.expr = expr;
    }

    @Override
    public EqlPart createPart() {
        return new UnlessPart(this.expr, this.multiPart);
    }

    @Override
    public int parse(List<String> mergedLines, int index) {
        int i;
        int ii = mergedLines.size();
        for (i = index; i < ii; ++i) {
            String clearLine;
            String line = mergedLines.get(i);
            if (line.startsWith("--")) {
                clearLine = ParserUtils.substr(line, "--".length());
            } else {
                Matcher matcher = ParserUtils.inlineComment.matcher(line);
                if (matcher.matches()) {
                    clearLine = matcher.group(1).trim();
                } else {
                    this.multiPart.addPart(new LiteralPart(line));
                    continue;
                }
            }
            if ("end".equalsIgnoreCase(clearLine)) {
                return i + 1;
            }
            PartParser partParser = PartParserFactory.tryParse(clearLine);
            if (partParser == null) continue;
            i = partParser.parse(mergedLines, i + 1) - 1;
            this.multiPart.addPart(partParser.createPart());
        }
        return i;
    }
}

