/*
 * Decompiled with CFR 0.152.
 */
package org.n3r.eql.util;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.n3r.eql.util.P;

public class BeanPropertyReader {
    private Class<? extends Object> beanClass;
    private String property;
    private Object bean;
    private Object propertyValue;
    private boolean hasProperty;
    private String capitalizedProperty;

    public BeanPropertyReader(Object bean, String property) {
        if (bean == null) {
            return;
        }
        this.bean = bean;
        this.property = property;
        this.beanClass = bean.getClass();
        this.capitalizedProperty = StringUtils.capitalize((String)property);
        if (bean instanceof Map) {
            Map map = (Map)bean;
            this.propertyValue = map.get(property);
            boolean bl = this.hasProperty = this.propertyValue != null;
        }
        if (this.tryField()) {
            return;
        }
        if (this.tryGetMethod()) {
            return;
        }
        this.tryIsMethod();
    }

    private void tryIsMethod() {
        try {
            Method isMethod = this.beanClass.getMethod("is" + this.capitalizedProperty, new Class[0]);
            this.hasProperty = true;
            Object value = isMethod.invoke(this.bean, new Object[0]);
            this.propertyValue = P.toDbConvert(isMethod, value);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private boolean tryGetMethod() {
        try {
            Method getMethod = this.beanClass.getMethod("get" + StringUtils.capitalize((String)this.property), new Class[0]);
            this.hasProperty = true;
            Object value = getMethod.invoke(this.bean, new Object[0]);
            this.propertyValue = P.toDbConvert(getMethod, value);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    private boolean tryField() {
        try {
            Field keyField = this.beanClass.getDeclaredField(this.property);
            if (!keyField.isAccessible()) {
                keyField.setAccessible(true);
            }
            this.hasProperty = true;
            Object value = keyField.get(this.bean);
            this.propertyValue = P.toDbConvert(keyField, value);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public boolean existsProperty() {
        return this.hasProperty;
    }

    public Object readProperty() {
        return this.propertyValue;
    }
}

