/*
 * Decompiled with CFR 0.152.
 */
package org.n3r.eql.util;

import com.google.common.base.Charsets;
import com.google.common.base.MoreObjects;
import com.google.common.base.Strings;
import com.google.common.io.Resources;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.List;
import org.n3r.eql.util.EqlUtils;

public class C {
    public static boolean classExists(String className) {
        try {
            Class.forName(className);
            return true;
        }
        catch (Throwable e) {
            return false;
        }
    }

    public static String getSqlClassPath(int num, String extension) {
        StackTraceElement[] stackTraceElements = Thread.currentThread().getStackTrace();
        int adjusted = stackTraceElements[0].isNativeMethod() ? 1 : 0;
        String callerClassName = stackTraceElements[num + adjusted].getClassName();
        return callerClassName.replace('.', '/') + "." + extension;
    }

    public static <T> Class<T> tryLoadClass(String className) {
        if (Strings.isNullOrEmpty((String)className)) {
            return null;
        }
        try {
            return C.getClassLoader().loadClass(className);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    public static ClassLoader getClassLoader() {
        return (ClassLoader)MoreObjects.firstNonNull((Object)Thread.currentThread().getContextClassLoader(), (Object)EqlUtils.class.getClassLoader());
    }

    public static InputStream classResourceToInputStream(String pathname, boolean silent) {
        InputStream is = C.classResourceToStream(pathname);
        if (is != null || silent) {
            return is;
        }
        throw new RuntimeException("fail to find " + pathname + " in current dir or classpath");
    }

    public static InputStream classResourceToStream(String resourceName) {
        return C.getClassLoader().getResourceAsStream(resourceName);
    }

    public static boolean classResourceExists(String classPath) {
        URL url = C.getClassLoader().getResource(classPath);
        return url != null;
    }

    public static String classResourceToString(String classPath) {
        URL url = C.getClassLoader().getResource(classPath);
        if (url == null) {
            return null;
        }
        return Resources.toString((URL)url, (Charset)Charsets.UTF_8);
    }

    public static List<String> classResourceToLines(String classPath) {
        URL url = C.getClassLoader().getResource(classPath);
        if (url == null) {
            return null;
        }
        return Resources.readLines((URL)url, (Charset)Charsets.UTF_8);
    }
}

