/*
 * Decompiled with CFR 0.152.
 */
package org.n3r.eql.util;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.sql.DataSource;
import org.n3r.eql.base.ExpressionEvaluator;
import org.n3r.eql.config.EqlConfig;
import org.n3r.eql.map.EqlRun;
import org.n3r.eql.util.HostAddress;
import org.n3r.eql.util.Logs;
import org.n3r.eql.util.S;
import org.slf4j.Logger;

public class EqlUtils {
    public static void compatibleWithUserToUsername(Map<String, String> params) {
        if (params.containsKey("username")) {
            return;
        }
        if (params.containsKey("user")) {
            params.put("username", params.get("user"));
        }
    }

    public static String getDriverNameFromConnection(DataSource dataSource) {
        String string;
        block6: {
            Connection connection = dataSource.getConnection();
            try {
                string = connection.getMetaData().getDriverName();
                if (Collections.singletonList(connection).get(0) == null) break block6;
            }
            catch (Throwable throwable) {
                if (Collections.singletonList(connection).get(0) != null) {
                    connection.close();
                }
                throw throwable;
            }
            connection.close();
        }
        return string;
    }

    public static String getJdbcUrlFromConnection(DataSource dataSource) {
        String string;
        block6: {
            Connection connection = dataSource.getConnection();
            try {
                string = connection.getMetaData().getURL();
                if (Collections.singletonList(connection).get(0) == null) break block6;
            }
            catch (Throwable throwable) {
                if (Collections.singletonList(connection).get(0) != null) {
                    connection.close();
                }
                throw throwable;
            }
            connection.close();
        }
        return string;
    }

    public static Map<String, Object> newExecContext(Object[] params, Object[] dynamics) {
        HashMap executionContext = Maps.newHashMap();
        executionContext.put("_time", new Timestamp(System.currentTimeMillis()));
        executionContext.put("_date", new Date());
        executionContext.put("_host", HostAddress.getHost());
        executionContext.put("_ip", HostAddress.getIp());
        executionContext.put("_results", Lists.newArrayList());
        executionContext.put("_lastResult", "");
        executionContext.put("_params", params);
        if (params != null) {
            executionContext.put("_paramsCount", params.length);
            for (int i = 0; i < params.length; ++i) {
                executionContext.put("_" + (i + 1), params[i]);
            }
        }
        executionContext.put("_dynamics", dynamics);
        if (dynamics != null) {
            executionContext.put("_dynamicsCount", dynamics.length);
        }
        return executionContext;
    }

    public static String trimLastUnusedPart(String sql) {
        String returnSql = S.trimRight(sql);
        String upper = S.upperCase(returnSql);
        if (S.endsWith(upper, "WHERE")) {
            return returnSql.substring(0, sql.length() - "WHERE".length());
        }
        if (S.endsWith(upper, "AND")) {
            return returnSql.substring(0, sql.length() - "AND".length());
        }
        if (S.endsWith(upper, "OR")) {
            return returnSql.substring(0, sql.length() - "AND".length());
        }
        return returnSql;
    }

    public static PreparedStatement prepareSQL(String sqlClassPath, EqlConfig eqlConfig, EqlRun eqlRun, String sqlId, String tagSqlId) {
        Logger log = Logs.createLogger(eqlConfig, sqlClassPath, sqlId, tagSqlId, "prepare");
        log.debug(eqlRun.getPrintSql());
        Connection conn = eqlRun.getConnection();
        String sql = eqlRun.getRunSql();
        boolean procedure = eqlRun.getSqlType().isProcedure();
        PreparedStatement ps = procedure ? conn.prepareCall(sql) : conn.prepareStatement(sql);
        EqlUtils.setQueryTimeout(eqlConfig, ps);
        return ps;
    }

    public static int getConfigInt(EqlConfig eqlConfig, String key, int defaultValue) {
        String configValue = eqlConfig.getStr(key);
        if (S.isBlank(configValue)) {
            return defaultValue;
        }
        if (configValue.matches("\\d+")) {
            return Integer.parseInt(configValue);
        }
        return defaultValue;
    }

    public static void setQueryTimeout(EqlConfig eqlConfig, Statement stmt) {
        int queryTimeout = EqlUtils.getConfigInt(eqlConfig, "query.timeout.seconds", 60);
        if (queryTimeout <= 0) {
            queryTimeout = 60;
        }
        stmt.setQueryTimeout(queryTimeout);
    }

    public static Iterable<?> evalCollection(String collectionExpr, EqlRun eqlRun) {
        ExpressionEvaluator evaluator = eqlRun.getEqlConfig().getExpressionEvaluator();
        Object value = evaluator.eval(collectionExpr, eqlRun);
        if (value == null) {
            return null;
        }
        if (value instanceof Iterable) {
            return (Iterable)value;
        }
        if (value.getClass().isArray()) {
            return Lists.newArrayList((Object[])((Object[])value));
        }
        throw new RuntimeException(collectionExpr + " in " + eqlRun.getParamBean() + " is not an expression of a collection");
    }
}

