/*
 * Decompiled with CFR 0.152.
 */
package org.n3r.eql.util;

import com.google.common.base.Optional;
import com.google.common.collect.Maps;
import java.beans.BeanInfo;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.HashMap;
import java.util.Map;
import org.n3r.eql.base.EqlToProperties;
import org.n3r.eql.util.BeanPropertyReader;
import org.n3r.eql.util.O;
import org.n3r.eql.util.P;

public class MapInvocationHandler
implements InvocationHandler {
    private final Map<String, Object> context;
    private final Object bean;
    private Map<String, Object> merged;

    public MapInvocationHandler(Map<String, Object> context, Object bean) {
        this.context = context;
        this.bean = bean instanceof EqlToProperties ? ((EqlToProperties)((Object)bean)).toProperties() : bean;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        boolean isGet = method.getName().equals("get");
        if (!isGet) {
            if (this.merged == null) {
                this.merged = MapInvocationHandler.mergeProperties(this.context, this.bean);
            }
            return method.invoke(this.merged, args);
        }
        if (this.merged != null) {
            return this.merged.get(args[0]);
        }
        BeanPropertyReader propertyReader = new BeanPropertyReader(this.bean, (String)args[0]);
        if (propertyReader.existsProperty()) {
            return propertyReader.readProperty();
        }
        return this.context != null ? this.context.get(args[0]) : null;
    }

    public static Map<String, Object> proxy(Map<String, Object> context, Object bean) {
        ClassLoader classLoader = P.class.getClassLoader();
        MapInvocationHandler handler = new MapInvocationHandler(context, bean);
        Object proxy = Proxy.newProxyInstance(classLoader, new Class[]{Map.class}, (InvocationHandler)handler);
        return (Map)proxy;
    }

    private static Map<String, Object> mergeProperties(Map<String, Object> context, Object bean) {
        HashMap map = Maps.newHashMap(context);
        if (bean == null) {
            return map;
        }
        if (bean instanceof Map) {
            map.putAll((Map)bean);
            return map;
        }
        if (bean instanceof EqlToProperties) {
            map.putAll(((EqlToProperties)bean).toProperties());
        } else {
            MapInvocationHandler.mergeBeanProperties(bean, map);
        }
        return map;
    }

    private static void mergeBeanProperties(Object bean, Map<String, Object> map) {
        MapInvocationHandler.mergeReadProperties(bean, map);
        MapInvocationHandler.mergeDeclaredFields(bean, map);
    }

    private static void mergeDeclaredFields(Object bean, Map<String, Object> map) {
        for (Field field : bean.getClass().getDeclaredFields()) {
            try {
                field.setAccessible(true);
                Object value = field.get(bean);
                value = P.toDbConvert(field, value);
                map.put(field.getName(), value);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private static void mergeReadProperties(Object bean, Map<String, Object> map) {
        BeanInfo info = O.getBeanInfo(bean.getClass());
        for (PropertyDescriptor pDesc : info.getPropertyDescriptors()) {
            Method method = pDesc.getReadMethod();
            if (method == null) continue;
            String name = pDesc.getName();
            Optional<Object> value = O.invokeMethod(bean, method);
            Object propertyValue = P.toDbConvert(method, value.orNull());
            map.put(name, propertyValue);
        }
    }
}

