/*
 * Decompiled with CFR 0.152.
 */
package org.n3r.eql.util;

import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.primitives.Primitives;
import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.n3r.eql.ex.EqlExecuteException;
import org.n3r.eql.joor.Reflect;
import org.n3r.eql.spec.ParamsAppliable;
import org.n3r.eql.spec.Spec;
import org.n3r.eql.util.PropertyValueFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class O {
    private static final Logger log = LoggerFactory.getLogger(O.class);

    public static <T> T populate(T object, Map<String, String> map, PropertyValueFilter ... propertyValueFilters) {
        HashMap<String, String> params = new HashMap<String, String>(map);
        for (Method method : object.getClass().getMethods()) {
            String propertyName;
            if (!O.isSetterMethod(method) || !params.containsKey(propertyName = O.getPropertyNameFromSetter(method))) continue;
            String propertyValue = (String)params.get(propertyName);
            for (PropertyValueFilter pvf : propertyValueFilters) {
                propertyValue = pvf.filter(propertyValue);
            }
            boolean ok = O.populateProperty(object, method, propertyName, propertyValue);
            if (!ok) continue;
            params.remove(propertyName);
        }
        return object;
    }

    public static String getPropertyNameFromSetter(Method method) {
        String propertyName = method.getName().substring(3);
        char lower = Character.toLowerCase(propertyName.charAt(0));
        return lower + propertyName.substring(1);
    }

    public static boolean isSetterMethod(Method method) {
        Class<?> returnType = method.getReturnType();
        String methodName = method.getName();
        return Modifier.isPublic(method.getModifiers()) && (returnType == Void.TYPE || returnType == Void.TYPE) && methodName.length() > 3 && methodName.startsWith("set") && method.getParameterTypes().length == 1;
    }

    private static <T> boolean populateProperty(T object, Method method, String propertyName, String propertyValue) {
        Class<?> paramType = method.getParameterTypes()[0];
        try {
            if (paramType == String.class) {
                method.invoke(object, propertyValue);
                return true;
            }
            if (paramType == Long.class || paramType == Long.TYPE) {
                if (propertyValue.matches("\\d+")) {
                    method.invoke(object, Long.parseLong(propertyValue));
                    return true;
                }
            } else if (paramType == Integer.class || paramType == Integer.TYPE) {
                if (propertyValue.matches("\\d+")) {
                    method.invoke(object, Integer.parseInt(propertyValue));
                    return true;
                }
            } else if (paramType == Boolean.class || paramType == Boolean.TYPE) {
                method.invoke(object, Boolean.parseBoolean(propertyValue));
                return true;
            }
        }
        catch (Exception e) {
            log.warn("{}:{} is not used by {}", new Object[]{propertyName, propertyValue, e.getMessage()});
        }
        return false;
    }

    public static <T> T createObject(Class<T> clazz, Spec spec) {
        Object object = Reflect.on(spec.getName()).create().get();
        if (!clazz.isInstance(object)) {
            throw new EqlExecuteException(spec.getName() + " does not implement " + clazz);
        }
        if (object instanceof ParamsAppliable) {
            ((ParamsAppliable)object).applyParams(spec.getParams());
        }
        return object;
    }

    public static <T> boolean in(T target, T ... compares) {
        for (T compare : compares) {
            if (!Objects.equal(target, compare)) continue;
            return true;
        }
        return false;
    }

    public static Object createSingleBean(Object[] params) {
        if (params == null || params.length == 0) {
            return new Object();
        }
        if (params.length > 1) {
            return ImmutableMap.of((Object)"_params", (Object)params);
        }
        Object param = params[0];
        if (param == null || param.getClass().isPrimitive() || Primitives.isWrapperType(param.getClass()) || param instanceof String || param.getClass().isArray() || param instanceof Collection) {
            return ImmutableMap.of((Object)"_params", (Object)params);
        }
        return param;
    }

    public static boolean setProperty(Object object, PropertyDescriptor pd, Object value) {
        Method setter = pd.getWriteMethod();
        if (setter == null) {
            return false;
        }
        try {
            O.setAccessibleTrue(setter);
            setter.invoke(object, value);
            return true;
        }
        catch (Exception e) {
            log.warn("set value by error {}", (Object)e.getMessage());
            return false;
        }
    }

    public static Optional<Object> invokeMethod(Object bean, Method method) {
        try {
            return Optional.fromNullable((Object)method.invoke(bean, new Object[0]));
        }
        catch (InvocationTargetException e) {
            throw e.getCause() != null ? e.getCause() : e;
        }
    }

    public static BeanInfo getBeanInfo(Class<?> aClass) {
        return Introspector.getBeanInfo(aClass);
    }

    public static boolean setValue(Object mappedObject, String columnName, ValueGettable valueGettable) {
        if (mappedObject instanceof Map) {
            ((Map)mappedObject).put(columnName, valueGettable.getValue());
            return true;
        }
        int dotPos = columnName.indexOf(46);
        if (dotPos < 0) {
            return O.setProperty(mappedObject, columnName, valueGettable);
        }
        String property = columnName.substring(0, dotPos);
        Object propertyValue = O.getOrCreateProperty(property, mappedObject);
        if (propertyValue == null) {
            return false;
        }
        String nestProperty = columnName.substring(dotPos + 1);
        return O.setValue(propertyValue, nestProperty, valueGettable);
    }

    public static Object getOrCreateProperty(String propertyName, Object hostBean) {
        Object property = O.getProperty(propertyName, hostBean);
        if (property != null) {
            return property;
        }
        Class<?> returnType = O.getPropertyType(propertyName, hostBean);
        if (Map.class.isAssignableFrom(returnType)) {
            property = Maps.newHashMap();
        }
        if (property == null) {
            property = Reflect.on(returnType).create().get();
        }
        O.setProperty(hostBean, propertyName, new ObjectGetter(property));
        return property;
    }

    public static Class<?> getPropertyType(String propertyName, Object hostBean) {
        String methodName = O.getGetMethodName(propertyName);
        try {
            Method m = O.getAccessibleMethod(hostBean, methodName);
            return m.getReturnType();
        }
        catch (NoSuchMethodException e) {
            log.debug("NoSuchMethodException invoke get method of property {} of {}", (Object)propertyName, hostBean);
        }
        catch (Exception e) {
            log.debug("invoke method exception", (Throwable)e);
        }
        try {
            Field field = O.getAccessibleField(hostBean, propertyName);
            return field.getType();
        }
        catch (Exception e) {
            log.debug("invoke method exception", (Throwable)e);
            throw new RuntimeException("unable to get property " + propertyName + " type of " + hostBean);
        }
    }

    public static Object getProperty(String propertyName, Object hostBean) {
        String methodName = O.getGetMethodName(propertyName);
        try {
            Method m = O.getAccessibleMethod(hostBean, methodName);
            return m.invoke(hostBean, new Object[0]);
        }
        catch (NoSuchMethodException e) {
            log.debug("NoSuchMethodException invoke get method of property {} of {}", (Object)propertyName, hostBean);
        }
        catch (Exception e) {
            log.debug("invoke method exception", (Throwable)e);
        }
        try {
            Field field = O.getAccessibleField(hostBean, propertyName);
            return field.get(hostBean);
        }
        catch (Exception e) {
            log.debug("invoke method exception", (Throwable)e);
            throw new RuntimeException("unable to get property value " + propertyName + " of bean " + hostBean);
        }
    }

    private static boolean setProperty(Object hostBean, String propertyName, ValueGettable valueGettable) {
        if (hostBean instanceof Map) {
            ((Map)hostBean).put(propertyName, valueGettable.getValue());
            return true;
        }
        return O.setBeanProperty(hostBean, propertyName, valueGettable);
    }

    private static boolean setBeanProperty(Object hostBean, String propertyName, ValueGettable valueGettable) {
        String methodName = O.getSetMethodName(propertyName);
        try {
            Method m = O.getAccessibleMethod(hostBean, methodName);
            m.invoke(hostBean, valueGettable.getValue(m.getReturnType()));
            return true;
        }
        catch (NoSuchMethodException m) {
        }
        catch (Exception e) {
            log.debug("invoke set method exception", (Throwable)e);
        }
        try {
            Field field = O.getAccessibleField(hostBean, propertyName);
            field.set(hostBean, valueGettable.getValue(field.getType()));
            return true;
        }
        catch (NoSuchFieldException field) {
        }
        catch (Exception e) {
            log.debug("invoke set field exception", (Throwable)e);
        }
        return false;
    }

    public static String getGetMethodName(String propertyName) {
        char upper = Character.toTitleCase(propertyName.charAt(0));
        return "get" + upper + propertyName.substring(1);
    }

    public static String getSetMethodName(String propertyName) {
        char upper = Character.toTitleCase(propertyName.charAt(0));
        return "set" + upper + propertyName.substring(1);
    }

    public static void setAccessibleTrue(AccessibleObject m) {
        if (!m.isAccessible()) {
            m.setAccessible(true);
        }
    }

    public static Method getAccessibleMethod(Object hostBean, String methodName) throws NoSuchMethodException {
        Method m = hostBean.getClass().getMethod(methodName, new Class[0]);
        O.setAccessibleTrue(m);
        return m;
    }

    public static Field getAccessibleField(Object hostBean, String propertyName) throws NoSuchFieldException {
        Field field = hostBean.getClass().getDeclaredField(propertyName);
        O.setAccessibleTrue(field);
        return field;
    }

    public static class ObjectGetter
    implements ValueGettable {
        private final Object value;

        public ObjectGetter(Object value) {
            this.value = value;
        }

        @Override
        public Object getValue() {
            return this.value;
        }

        @Override
        public Object getValue(Class<?> returnType) {
            return this.value;
        }
    }

    public static interface ValueGettable {
        public Object getValue();

        public Object getValue(Class<?> var1);
    }
}

