/*
 * Decompiled with CFR 0.152.
 */
package org.n3r.idworker;

import java.security.SecureRandom;
import org.n3r.idworker.InvalidSystemClock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IdWorker {
    protected long epoch = 1387886498127L;
    protected long workerIdBits = 10L;
    protected long maxWorkerId = 0xFFFFFFFFFFFFFFFFL ^ -1L << (int)this.workerIdBits;
    protected long sequenceBits;
    protected long workerIdShift = this.sequenceBits = 11L;
    protected long timestampLeftShift = this.sequenceBits + this.workerIdBits;
    protected long sequenceMask = 0xFFFFFFFFFFFFFFFFL ^ -1L << (int)this.sequenceBits;
    protected long lastMillis = -1L;
    protected final long workerId;
    protected long sequence = 0L;
    protected Logger logger = LoggerFactory.getLogger(IdWorker.class);

    public IdWorker(long workerId) {
        this.workerId = this.checkWorkerId(workerId);
        this.logger.debug("worker starting. timestamp left shift {}, worker id bits {}, sequence bits {}, worker id {}", new Object[]{this.timestampLeftShift, this.workerIdBits, this.sequenceBits, workerId});
    }

    public long getEpoch() {
        return this.epoch;
    }

    private long checkWorkerId(long workerId) {
        if (workerId > this.maxWorkerId || workerId < 0L) {
            int rand = new SecureRandom().nextInt((int)this.maxWorkerId + 1);
            this.logger.warn("worker Id can't be greater than {} or less than 0, use a random {}", (Object)this.maxWorkerId, (Object)rand);
            return rand;
        }
        return workerId;
    }

    public synchronized long nextId() {
        long timestamp = this.millisGen();
        if (timestamp < this.lastMillis) {
            this.logger.error("clock is moving backwards.  Rejecting requests until {}.", (Object)this.lastMillis);
            throw new InvalidSystemClock(String.format("Clock moved backwards.  Refusing to generate id for {} milliseconds", this.lastMillis - timestamp));
        }
        if (this.lastMillis == timestamp) {
            this.sequence = this.sequence + 1L & this.sequenceMask;
            if (this.sequence == 0L) {
                timestamp = this.tilNextMillis(this.lastMillis);
            }
        } else {
            this.sequence = 0L;
        }
        this.lastMillis = timestamp;
        long diff = timestamp - this.getEpoch();
        return diff << (int)this.timestampLeftShift | this.workerId << (int)this.workerIdShift | this.sequence;
    }

    protected long tilNextMillis(long lastMillis) {
        long millis = this.millisGen();
        while (millis <= lastMillis) {
            millis = this.millisGen();
        }
        return millis;
    }

    protected long millisGen() {
        return System.currentTimeMillis();
    }

    public long getLastMillis() {
        return this.lastMillis;
    }

    public long getWorkerId() {
        return this.workerId;
    }
}

