/*
 * Decompiled with CFR 0.152.
 */
package org.n3r.idworker;

import java.text.SimpleDateFormat;
import java.util.Date;
import org.n3r.idworker.IdWorker;
import org.n3r.idworker.WorkerIdStrategy;
import org.n3r.idworker.strategy.DefaultWorkerIdStrategy;
import org.n3r.idworker.utils.Utils;

public class Sid {
    private static WorkerIdStrategy workerIdStrategy;
    private static IdWorker idWorker;

    public static synchronized void configure(WorkerIdStrategy custom) {
        if (workerIdStrategy != null) {
            workerIdStrategy.release();
        }
        workerIdStrategy = custom;
        idWorker = new IdWorker(workerIdStrategy.availableWorkerId()){

            @Override
            public long getEpoch() {
                return Utils.midnightMillis();
            }
        };
    }

    public static String next() {
        long id = idWorker.nextId();
        String yyMMdd = new SimpleDateFormat("yyMMdd").format(new Date());
        return yyMMdd + String.format("%014d", id);
    }

    public static String nextShort() {
        long id = idWorker.nextId();
        String yyMMdd = new SimpleDateFormat("yyMMdd").format(new Date());
        return yyMMdd + Utils.padLeft(Utils.encode(id), 10, '0');
    }

    static {
        Sid.configure(DefaultWorkerIdStrategy.instance);
    }
}

