/*
 * Decompiled with CFR 0.152.
 */
package org.n3r.idworker.strategy;

import java.text.SimpleDateFormat;
import java.util.Date;
import org.n3r.idworker.strategy.DefaultRandomCodeStrategy;

public class DayPrefixRandomCodeStrategy
extends DefaultRandomCodeStrategy {
    private final String dayFormat;
    private String lastDay;

    public DayPrefixRandomCodeStrategy(String dayFormat) {
        this.dayFormat = dayFormat;
    }

    @Override
    public void init() {
        String day = this.createDate();
        if (day.equals(this.lastDay)) {
            throw new RuntimeException("init failed for day unrolled");
        }
        this.lastDay = day;
        this.availableCodes.clear();
        this.release();
        this.prefixIndex = Integer.parseInt(this.lastDay);
        if (this.tryUsePrefix()) {
            return;
        }
        throw new RuntimeException("prefix is not available " + this.prefixIndex);
    }

    private String createDate() {
        return new SimpleDateFormat(this.dayFormat).format(new Date());
    }

    @Override
    public int next() {
        if (!this.lastDay.equals(this.createDate())) {
            this.init();
        }
        return super.next();
    }
}

