/*
 * Decompiled with CFR 0.152.
 */
package org.n3r.idworker.strategy;

import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.nio.channels.Channels;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.FileChannel;
import java.nio.channels.OverlappingFileLockException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileLock {
    private final File file;
    private FileChannel channel;
    private java.nio.channels.FileLock flock = null;
    Logger logger = LoggerFactory.getLogger(FileLock.class);

    public FileLock(File file) {
        this.file = file;
        try {
            file.createNewFile();
            this.channel = new RandomAccessFile(file, "rw").getChannel();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void lock() {
        try {
            FileLock fileLock = this;
            synchronized (fileLock) {
                this.logger.trace("Acquiring lock on {}", (Object)this.file.getAbsolutePath());
                this.flock = this.channel.lock();
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean tryLock() {
        FileLock fileLock = this;
        synchronized (fileLock) {
            this.logger.trace("Acquiring lock on {}", (Object)this.file.getAbsolutePath());
            try {
                this.flock = this.channel.tryLock();
                return this.flock != null;
            }
            catch (OverlappingFileLockException e) {
                return false;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unlock() {
        FileLock fileLock = this;
        synchronized (fileLock) {
            this.logger.trace("Releasing lock on {}", (Object)this.file.getAbsolutePath());
            if (this.flock == null) {
                return;
            }
            try {
                this.flock.release();
            }
            catch (ClosedChannelException closedChannelException) {
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        FileLock fileLock = this;
        synchronized (fileLock) {
            this.unlock();
            if (!this.channel.isOpen()) {
                return;
            }
            try {
                this.channel.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public <T> T readObject() {
        try {
            InputStream is = Channels.newInputStream(this.channel);
            ObjectInputStream objectReader = new ObjectInputStream(is);
            return (T)objectReader.readObject();
        }
        catch (EOFException is) {
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return null;
    }

    public synchronized boolean writeObject(Object object) {
        if (!this.channel.isOpen()) {
            return false;
        }
        try {
            this.channel.position(0L);
            OutputStream out = Channels.newOutputStream(this.channel);
            ObjectOutputStream objectOutput = new ObjectOutputStream(out);
            objectOutput.writeObject(object);
            return true;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

