/*
 * Decompiled with CFR 0.152.
 */
package org.n3r.idworker.utils;

import java.util.regex.Pattern;

public class IPv4Utils {
    public static long toLong(String ipAddress) {
        if (ipAddress == null || ipAddress.isEmpty()) {
            throw new IllegalArgumentException("ip address cannot be null or empty");
        }
        String[] octets = ipAddress.split(Pattern.quote("."));
        if (octets.length != 4) {
            throw new IllegalArgumentException("invalid ip address");
        }
        long ip = 0L;
        for (int i = 3; i >= 0; --i) {
            long octet = Long.parseLong(octets[3 - i]);
            if (octet > 255L || octet < 0L) {
                throw new IllegalArgumentException("invalid ip address");
            }
            ip |= octet << i * 8;
        }
        return ip;
    }

    public static String toString(long ip) {
        if (ip > 0xFFFFFFFFL || ip < 0L) {
            throw new IllegalArgumentException("invalid ip");
        }
        StringBuilder ipAddress = new StringBuilder();
        for (int i = 3; i >= 0; --i) {
            int shift = i * 8;
            ipAddress.append((ip & (long)(255 << shift)) >> shift);
            if (i <= 0) continue;
            ipAddress.append(".");
        }
        return ipAddress.toString();
    }
}

