/*
 * Decompiled with CFR 0.152.
 */
package org.n3r.idworker.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.n3r.idworker.utils.Serializes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Props {
    static Logger log = LoggerFactory.getLogger(Props.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties tryProperties(String propertiesFileName, String userHomeBasePath) {
        InputStream is;
        Properties properties;
        block4: {
            properties = new Properties();
            is = null;
            try {
                is = Props.tryResource(propertiesFileName, userHomeBasePath, Silent.ON);
                if (is == null) break block4;
                properties.load(is);
            }
            catch (IOException e) {
                try {
                    log.error("load properties error: {}", (Object)e.getMessage());
                }
                catch (Throwable throwable) {
                    Serializes.closeQuietly(is);
                    throw throwable;
                }
                Serializes.closeQuietly(is);
            }
        }
        Serializes.closeQuietly(is);
        return properties;
    }

    public static InputStream tryResource(String propertiesFileName, String userHomeBasePath, Silent silent) {
        InputStream is = Props.currentDirResource(new File(propertiesFileName));
        if (is != null) {
            return is;
        }
        is = Props.userHomeResource(propertiesFileName, userHomeBasePath);
        if (is != null) {
            return is;
        }
        is = Props.classpathResource(propertiesFileName);
        if (is != null || silent == Silent.ON) {
            return is;
        }
        throw new RuntimeException("fail to find " + propertiesFileName + " in current dir or classpath");
    }

    private static InputStream userHomeResource(String pathname, String appHome) {
        String filePath = System.getProperty("user.home") + File.separator + appHome;
        File dir = new File(filePath);
        if (!dir.exists()) {
            return null;
        }
        return Props.currentDirResource(new File(dir, pathname));
    }

    private static InputStream currentDirResource(File file) {
        if (!file.exists()) {
            return null;
        }
        try {
            return new FileInputStream(file);
        }
        catch (FileNotFoundException e) {
            log.error("read file {} error", (Object)file, (Object)e);
            return null;
        }
    }

    public static InputStream classpathResource(String resourceName) {
        return Props.class.getClassLoader().getResourceAsStream(resourceName);
    }

    static enum Silent {
        ON,
        OFF;

    }
}

