/*
 * Decompiled with CFR 0.152.
 */
package cn.beecp.pool;

import cn.beecp.pool.CacheKey;
import cn.beecp.pool.PooledConnection;
import cn.beecp.pool.ProxyConnectionBase;
import cn.beecp.pool.ProxyCsStatement;
import cn.beecp.pool.ProxyDatabaseMetaData;
import cn.beecp.pool.ProxyPsStatement;
import cn.beecp.pool.ProxyStatement;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.Map;
import java.util.Properties;

public final class ProxyConnection
extends ProxyConnectionBase
implements Connection {
    public ProxyConnection(PooledConnection pooledConnection) {
        super(pooledConnection);
    }

    @Override
    public Statement createStatement() throws SQLException {
        this.checkClosed();
        return new ProxyStatement(this.delegate.createStatement(), this, this.pConn);
    }

    @Override
    public PreparedStatement prepareStatement(String string) throws SQLException {
        this.checkClosed();
        if (this.pConn.stmCacheValid) {
            CacheKey cacheKey = new CacheKey(11, string);
            Object object = this.pConn.get(cacheKey);
            if (object == null) {
                object = this.delegate.prepareStatement(string);
                this.pConn.put(cacheKey, object);
            }
            return new ProxyPsStatement((PreparedStatement)object, this, this.pConn, true);
        }
        return new ProxyPsStatement(this.delegate.prepareStatement(string), this, this.pConn, false);
    }

    @Override
    public CallableStatement prepareCall(String string) throws SQLException {
        this.checkClosed();
        if (this.pConn.stmCacheValid) {
            CacheKey cacheKey = new CacheKey(21, string);
            CallableStatement callableStatement = (CallableStatement)this.pConn.get(cacheKey);
            if (callableStatement == null) {
                callableStatement = this.delegate.prepareCall(string);
                this.pConn.put(cacheKey, callableStatement);
            }
            return new ProxyCsStatement(callableStatement, this, this.pConn, true);
        }
        return new ProxyCsStatement(this.delegate.prepareCall(string), this, this.pConn, false);
    }

    @Override
    public String nativeSQL(String string) throws SQLException {
        this.checkClosed();
        return this.delegate.nativeSQL(string);
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        this.checkClosed();
        return this.delegate.getAutoCommit();
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        this.checkClosed();
        return new ProxyDatabaseMetaData(this.delegate.getMetaData(), this, this.pConn);
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        this.checkClosed();
        return this.delegate.isReadOnly();
    }

    @Override
    public String getCatalog() throws SQLException {
        this.checkClosed();
        return this.delegate.getCatalog();
    }

    @Override
    public int getTransactionIsolation() throws SQLException {
        this.checkClosed();
        return this.delegate.getTransactionIsolation();
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        this.checkClosed();
        return this.delegate.getWarnings();
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.checkClosed();
        this.delegate.clearWarnings();
    }

    @Override
    public Statement createStatement(int n, int n2) throws SQLException {
        this.checkClosed();
        return new ProxyStatement(this.delegate.createStatement(n, n2), this, this.pConn);
    }

    @Override
    public PreparedStatement prepareStatement(String string, int n, int n2) throws SQLException {
        this.checkClosed();
        if (this.pConn.stmCacheValid) {
            CacheKey cacheKey = new CacheKey(12, string, n, n2);
            Object object = this.pConn.get(cacheKey);
            if (object == null) {
                object = this.delegate.prepareStatement(string, n, n2);
                this.pConn.put(cacheKey, object);
            }
            return new ProxyPsStatement((PreparedStatement)object, this, this.pConn, true);
        }
        return new ProxyPsStatement(this.delegate.prepareStatement(string, n, n2), this, this.pConn, false);
    }

    @Override
    public CallableStatement prepareCall(String string, int n, int n2) throws SQLException {
        this.checkClosed();
        if (this.pConn.stmCacheValid) {
            CacheKey cacheKey = new CacheKey(22, string, n, n2);
            CallableStatement callableStatement = (CallableStatement)this.pConn.get(cacheKey);
            if (callableStatement == null) {
                callableStatement = this.delegate.prepareCall(string, n, n2);
                this.pConn.put(cacheKey, callableStatement);
            }
            return new ProxyCsStatement(callableStatement, this, this.pConn, true);
        }
        return new ProxyCsStatement(this.delegate.prepareCall(string, n, n2), this, this.pConn, false);
    }

    public Map getTypeMap() throws SQLException {
        this.checkClosed();
        return this.delegate.getTypeMap();
    }

    public void setTypeMap(Map map) throws SQLException {
        this.checkClosed();
        this.delegate.setTypeMap(map);
    }

    @Override
    public void setHoldability(int n) throws SQLException {
        this.checkClosed();
        this.delegate.setHoldability(n);
    }

    @Override
    public int getHoldability() throws SQLException {
        this.checkClosed();
        return this.delegate.getHoldability();
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        this.checkClosed();
        return this.delegate.setSavepoint();
    }

    @Override
    public Savepoint setSavepoint(String string) throws SQLException {
        this.checkClosed();
        return this.delegate.setSavepoint(string);
    }

    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
        this.checkClosed();
        this.delegate.rollback(savepoint);
    }

    @Override
    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        this.checkClosed();
        this.delegate.releaseSavepoint(savepoint);
    }

    @Override
    public Statement createStatement(int n, int n2, int n3) throws SQLException {
        this.checkClosed();
        return new ProxyStatement(this.delegate.createStatement(n, n2, n3), this, this.pConn);
    }

    @Override
    public PreparedStatement prepareStatement(String string, int n, int n2, int n3) throws SQLException {
        this.checkClosed();
        if (this.pConn.stmCacheValid) {
            CacheKey cacheKey = new CacheKey(13, string, n, n2, n3);
            Object object = this.pConn.get(cacheKey);
            if (object == null) {
                object = this.delegate.prepareStatement(string, n, n2, n3);
                this.pConn.put(cacheKey, object);
            }
            return new ProxyPsStatement((PreparedStatement)object, this, this.pConn, true);
        }
        return new ProxyPsStatement(this.delegate.prepareStatement(string, n, n2, n3), this, this.pConn, false);
    }

    @Override
    public CallableStatement prepareCall(String string, int n, int n2, int n3) throws SQLException {
        this.checkClosed();
        if (this.pConn.stmCacheValid) {
            CacheKey cacheKey = new CacheKey(23, string, n, n2, n3);
            CallableStatement callableStatement = (CallableStatement)this.pConn.get(cacheKey);
            if (callableStatement == null) {
                callableStatement = this.delegate.prepareCall(string, n, n2, n3);
                this.pConn.put(cacheKey, callableStatement);
            }
            return new ProxyCsStatement(callableStatement, this, this.pConn, true);
        }
        return new ProxyCsStatement(this.delegate.prepareCall(string, n, n2, n3), this, this.pConn, false);
    }

    @Override
    public PreparedStatement prepareStatement(String string, int n) throws SQLException {
        this.checkClosed();
        if (this.pConn.stmCacheValid) {
            CacheKey cacheKey = new CacheKey(14, string, n);
            Object object = this.pConn.get(cacheKey);
            if (object == null) {
                object = this.delegate.prepareStatement(string, n);
                this.pConn.put(cacheKey, object);
            }
            return new ProxyPsStatement((PreparedStatement)object, this, this.pConn, true);
        }
        return new ProxyPsStatement(this.delegate.prepareStatement(string, n), this, this.pConn, false);
    }

    @Override
    public PreparedStatement prepareStatement(String string, int[] nArray) throws SQLException {
        this.checkClosed();
        if (this.pConn.stmCacheValid) {
            CacheKey cacheKey = new CacheKey(15, string, nArray);
            Object object = this.pConn.get(cacheKey);
            if (object == null) {
                object = this.delegate.prepareStatement(string, nArray);
                this.pConn.put(cacheKey, object);
            }
            return new ProxyPsStatement((PreparedStatement)object, this, this.pConn, true);
        }
        return new ProxyPsStatement(this.delegate.prepareStatement(string, nArray), this, this.pConn, false);
    }

    @Override
    public PreparedStatement prepareStatement(String string, String[] stringArray) throws SQLException {
        this.checkClosed();
        if (this.pConn.stmCacheValid) {
            CacheKey cacheKey = new CacheKey(16, string, stringArray);
            Object object = this.pConn.get(cacheKey);
            if (object == null) {
                object = this.delegate.prepareStatement(string, stringArray);
                this.pConn.put(cacheKey, object);
            }
            return new ProxyPsStatement((PreparedStatement)object, this, this.pConn, true);
        }
        return new ProxyPsStatement(this.delegate.prepareStatement(string, stringArray), this, this.pConn, false);
    }

    @Override
    public Clob createClob() throws SQLException {
        this.checkClosed();
        return this.delegate.createClob();
    }

    @Override
    public Blob createBlob() throws SQLException {
        this.checkClosed();
        return this.delegate.createBlob();
    }

    @Override
    public NClob createNClob() throws SQLException {
        this.checkClosed();
        return this.delegate.createNClob();
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        this.checkClosed();
        return this.delegate.createSQLXML();
    }

    @Override
    public void setClientInfo(String string, String string2) throws SQLClientInfoException {
        this.checkClosed();
        this.delegate.setClientInfo(string, string2);
    }

    @Override
    public void setClientInfo(Properties properties) throws SQLClientInfoException {
        this.checkClosed();
        this.delegate.setClientInfo(properties);
    }

    @Override
    public String getClientInfo(String string) throws SQLException {
        this.checkClosed();
        return this.delegate.getClientInfo(string);
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        this.checkClosed();
        return this.delegate.getClientInfo();
    }

    @Override
    public Array createArrayOf(String string, Object[] objectArray) throws SQLException {
        this.checkClosed();
        return this.delegate.createArrayOf(string, objectArray);
    }

    @Override
    public Struct createStruct(String string, Object[] objectArray) throws SQLException {
        this.checkClosed();
        return this.delegate.createStruct(string, objectArray);
    }

    @Override
    public String getSchema() throws SQLException {
        this.checkClosed();
        return this.delegate.getSchema();
    }
}

