/*
 * Decompiled with CFR 0.152.
 */
package cn.beecp.pool;

import cn.beecp.pool.PoolExceptionList;
import cn.beecp.pool.PooledConnection;
import cn.beecp.pool.ProxyStatementBase;
import cn.beecp.util.BeecpUtil;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

abstract class ProxyResultSetBase
implements ResultSet {
    private boolean isClosed;
    protected ResultSet delegate;
    protected PooledConnection pConn;
    private ProxyStatementBase proxyStatement;
    private boolean proxyStatementIsNotNull;

    public ProxyResultSetBase(ResultSet delegate, ProxyStatementBase proxyStatement, PooledConnection pConn) {
        this.pConn = pConn;
        this.delegate = delegate;
        this.proxyStatement = proxyStatement;
        this.proxyStatementIsNotNull = proxyStatement != null;
    }

    @Override
    public Statement getStatement() throws SQLException {
        this.checkClosed();
        return (Statement)((Object)this.proxyStatement);
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.isClosed;
    }

    protected void checkClosed() throws SQLException {
        if (this.isClosed) {
            throw PoolExceptionList.ResultSetClosedException;
        }
        if (this.proxyStatementIsNotNull) {
            this.proxyStatement.checkClosed();
        }
    }

    @Override
    public void close() throws SQLException {
        this.checkClosed();
        this.isClosed = true;
        BeecpUtil.oclose(this.delegate);
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        this.checkClosed();
        return iface.isInstance(this);
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        this.checkClosed();
        if (iface.isInstance(this)) {
            return (T)this;
        }
        throw new SQLException("Wrapped object is not an instance of " + iface);
    }
}

