/*
 * Decompiled with CFR 0.152.
 */
package cn.beecp.pool;

import cn.beecp.pool.PoolExceptionList;
import cn.beecp.pool.PooledConnection;
import cn.beecp.pool.ProxyConnectionBase;
import cn.beecp.util.BeecpUtil;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;

class ProxyStatementBase {
    private boolean isClosed;
    private boolean cacheInd;
    protected Statement delegate;
    protected PooledConnection pConn;
    protected ProxyConnectionBase proxyConn;

    public ProxyStatementBase(Statement delegate, ProxyConnectionBase proxyConn, PooledConnection pConn, boolean cacheInd) {
        this.pConn = pConn;
        this.proxyConn = proxyConn;
        this.delegate = delegate;
        this.cacheInd = cacheInd;
    }

    public Connection getConnection() throws SQLException {
        this.checkClosed();
        return this.proxyConn;
    }

    public boolean isClosed() throws SQLException {
        return this.isClosed;
    }

    protected void checkClosed() throws SQLException {
        if (this.isClosed) {
            throw PoolExceptionList.StatementClosedException;
        }
        this.proxyConn.checkClosed();
    }

    public void close() throws SQLException {
        this.checkClosed();
        this.isClosed = true;
        if (!this.cacheInd) {
            BeecpUtil.oclose(this.delegate);
        }
    }

    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        this.checkClosed();
        return iface.isInstance(this);
    }

    public <T> T unwrap(Class<T> iface) throws SQLException {
        this.checkClosed();
        if (iface.isInstance(this)) {
            return (T)this;
        }
        throw new SQLException("Wrapped object is not an instance of " + iface);
    }
}

