/*
 * Decompiled with CFR 0.152.
 */
package cn.beecp.pool;

import cn.beecp.BeeDataSourceConfig;
import cn.beecp.pool.ConnectionPool;
import cn.beecp.pool.ConnectionPoolJMXBean;
import cn.beecp.pool.PoolExceptionList;
import cn.beecp.pool.PooledConnection;
import cn.beecp.util.BeecpUtil;
import java.lang.management.ManagementFactory;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RawConnectionPool
implements ConnectionPool,
ConnectionPoolJMXBean {
    private volatile boolean isShutdown;
    private Semaphore poolSemaphore;
    private long DefaultMaxWait;
    private BeeDataSourceConfig poolConfig;
    private String poolName;
    private static Logger log = LoggerFactory.getLogger(RawConnectionPool.class);
    private static AtomicInteger PoolNameIndex = new AtomicInteger(1);

    @Override
    public void init(BeeDataSourceConfig config) {
        this.poolConfig = config;
        this.DefaultMaxWait = TimeUnit.MILLISECONDS.toNanos(this.poolConfig.getMaxWait());
        this.poolSemaphore = new Semaphore(this.poolConfig.getBorrowConcurrentSize(), this.poolConfig.isFairMode());
        this.poolName = !BeecpUtil.isNullText(config.getPoolName()) ? config.getPoolName() : "RawPool-" + PoolNameIndex.getAndIncrement();
        String mode = this.poolConfig.isFairMode() ? "fair" : "compete";
        this.registerJMX();
        log.info("BeeCP({})has been startup{init size:{},max size:{},concurrent size:{},mode:{},max wait:{}ms},driver:{}}", new Object[]{this.poolName, 0, 0, this.poolConfig.getBorrowConcurrentSize(), mode, this.poolConfig.getDriverClassName()});
    }

    @Override
    public Connection getConnection() throws SQLException {
        try {
            if (this.isShutdown) {
                throw PoolExceptionList.PoolCloseException;
            }
            if (this.poolSemaphore.tryAcquire(this.DefaultMaxWait, TimeUnit.NANOSECONDS)) {
                Connection connection = this.poolConfig.getConnectionFactory().create();
                return connection;
            }
            try {
                throw PoolExceptionList.RequestTimeoutException;
            }
            catch (InterruptedException e) {
                throw PoolExceptionList.RequestInterruptException;
            }
        }
        finally {
            this.poolSemaphore.release();
        }
    }

    @Override
    public void recycle(PooledConnection pConn) {
    }

    @Override
    public void shutdown() {
        this.isShutdown = true;
        this.unregisterJMX();
    }

    @Override
    public boolean isShutdown() {
        return this.isShutdown;
    }

    @Override
    public void reset() {
    }

    @Override
    public void reset(boolean force) {
    }

    @Override
    public int getConnTotalSize() {
        return 0;
    }

    @Override
    public int getConnIdleSize() {
        return 0;
    }

    @Override
    public int getConnUsingSize() {
        return 0;
    }

    @Override
    public int getSemaphoreAcquiredSize() {
        return this.poolConfig.getBorrowConcurrentSize() - this.poolSemaphore.availablePermits();
    }

    @Override
    public int getSemaphoreWaitingSize() {
        return this.poolSemaphore.getQueueLength();
    }

    @Override
    public int getTransferWaitingSize() {
        return 0;
    }

    private void registerJMX() {
        if (this.poolConfig.isEnableJMX()) {
            MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
            try {
                ObjectName poolRegName = new ObjectName("cn.beecp.pool.RawConnectionPool:type=BeeCP(" + this.poolName + ")");
                if (!mBeanServer.isRegistered(poolRegName)) {
                    mBeanServer.registerMBean(this, poolRegName);
                    log.info("Registered BeeCP({})as jmx-bean", (Object)this.poolName);
                } else {
                    log.error("Jmx-name BeeCP({})has been exist in jmx server", (Object)this.poolName);
                }
            }
            catch (Exception e) {
                log.warn("Failed to register pool jmx-bean", (Throwable)e);
            }
            try {
                ObjectName configRegName = new ObjectName("cn.beecp.BeeDataSourceConfig:type=BeeCP(" + this.poolName + ")-config");
                if (!mBeanServer.isRegistered(configRegName)) {
                    mBeanServer.registerMBean(this.poolConfig, configRegName);
                    log.info("Registered BeeCP({})config as jmx-bean", (Object)this.poolName);
                } else {
                    log.error("Pool BeeCP({})config has been exist in jmx server", (Object)this.poolName);
                }
            }
            catch (Exception e) {
                log.warn("Failed to register pool jmx-bean", (Throwable)e);
            }
        }
    }

    private void unregisterJMX() {
        if (this.poolConfig.isEnableJMX()) {
            MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
            try {
                ObjectName poolRegName = new ObjectName("cn.beecp.pool.RawConnectionPool:type=BeeCP(" + this.poolName + ")");
                if (mBeanServer.isRegistered(poolRegName)) {
                    mBeanServer.unregisterMBean(poolRegName);
                }
            }
            catch (Exception e) {
                log.warn("Failed to unregister pool jmx-bean", (Throwable)e);
            }
            try {
                ObjectName configRegName = new ObjectName("cn.beecp.BeeDataSourceConfig:type=BeeCP(" + this.poolName + ")-config");
                if (mBeanServer.isRegistered(configRegName)) {
                    mBeanServer.unregisterMBean(configRegName);
                }
            }
            catch (Exception e) {
                log.warn("Failed to unregister pool jmx-bean", (Throwable)e);
            }
        }
    }
}

