/*
 * Decompiled with CFR 0.152.
 */
package cn.beecp.util;

import java.util.AbstractQueue;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.concurrent.locks.LockSupport;

public final class FastTransferQueue<E>
extends AbstractQueue<E> {
    private static final State STS_NORMAL = new State();
    private static final State STS_WAITING = new State();
    private static final State STS_FAILED = new State();
    private static final long spinForTimeoutThreshold = 1000L;
    private static final int maxTimedSpins = Runtime.getRuntime().availableProcessors() < 2 ? 0 : 32;
    private static final InterruptedException RequestInterruptException = new InterruptedException();
    private static final AtomicReferenceFieldUpdater<Waiter, Object> TransferUpdater = AtomicReferenceFieldUpdater.newUpdater(Waiter.class, Object.class, "state");
    private final ConcurrentLinkedQueue<E> elementQueue = new ConcurrentLinkedQueue();
    private final ConcurrentLinkedQueue<Waiter> waiterQueue = new ConcurrentLinkedQueue();

    @Override
    public E peek() {
        return this.elementQueue.peek();
    }

    @Override
    public int size() {
        return this.elementQueue.size();
    }

    @Override
    public Iterator<E> iterator() {
        return this.elementQueue.iterator();
    }

    @Override
    public boolean offer(E e) {
        return this.tryTransfer(e) ? true : this.elementQueue.offer(e);
    }

    public boolean tryTransfer(E e) {
        Waiter waiter;
        while ((waiter = this.waiterQueue.poll()) != null) {
            Object state = waiter.state;
            while (state == STS_NORMAL || state == STS_WAITING) {
                if (TransferUpdater.compareAndSet(waiter, state, e)) {
                    if (state == STS_WAITING) {
                        LockSupport.unpark(waiter.thread);
                    }
                    return true;
                }
                state = waiter.state;
            }
        }
        return false;
    }

    @Override
    public E poll() {
        return this.elementQueue.poll();
    }

    public E poll(long timeout, TimeUnit unit) throws InterruptedException {
        E e = this.elementQueue.poll();
        if (e != null) {
            return e;
        }
        boolean isFailed = false;
        boolean isInterrupted = false;
        Waiter waiter = new Waiter();
        Thread thread = waiter.thread;
        this.waiterQueue.offer(waiter);
        int spinSize = this.waiterQueue.peek() == waiter ? maxTimedSpins : 0;
        long deadline = System.nanoTime() + unit.toNanos(timeout);
        Object state;
        while ((state = waiter.state) instanceof State) {
            if (isFailed) {
                if (!TransferUpdater.compareAndSet(waiter, state, STS_FAILED)) continue;
                this.waiterQueue.remove(waiter);
                if (isInterrupted) {
                    throw RequestInterruptException;
                }
                return null;
            }
            timeout = deadline - System.nanoTime();
            if (timeout > 0L) {
                if (spinSize > 0) {
                    --spinSize;
                    continue;
                }
                if (timeout <= 1000L || !TransferUpdater.compareAndSet(waiter, state, STS_WAITING)) continue;
                LockSupport.parkNanos(this, timeout);
                if (!thread.isInterrupted()) continue;
                isFailed = true;
                isInterrupted = true;
                continue;
            }
            isFailed = true;
        }
        return (E)state;
    }

    public final boolean hasConsumerQueuedThreads() {
        return !this.waiterQueue.isEmpty();
    }

    public final int getConsumerQueueLength() {
        return this.waiterQueue.size();
    }

    public Collection<Thread> getConsumerQueuedThreads() {
        LinkedList<Thread> threadList = new LinkedList<Thread>();
        for (Waiter waiter : this.waiterQueue) {
            threadList.add(waiter.thread);
        }
        return threadList;
    }

    static /* synthetic */ State access$200() {
        return STS_NORMAL;
    }

    private static final class Waiter {
        Thread thread = Thread.currentThread();
        volatile Object state = FastTransferQueue.access$200();

        private Waiter() {
        }
    }

    private static final class State {
        private State() {
        }
    }
}

