/*
 * Decompiled with CFR 0.152.
 */
package HslCommunication.Profinet.Melsec.Helper;

import HslCommunication.Authorization;
import HslCommunication.BasicFramework.SoftBasic;
import HslCommunication.Core.Address.McAddressData;
import HslCommunication.Core.Types.OperateResult;
import HslCommunication.Core.Types.OperateResultExOne;
import HslCommunication.Profinet.Melsec.Helper.IReadWriteMc;
import HslCommunication.Profinet.Melsec.Helper.McAsciiHelper;
import HslCommunication.Profinet.Melsec.Helper.McBinaryHelper;
import HslCommunication.Profinet.Melsec.Helper.McType;
import HslCommunication.StringResources;
import HslCommunication.Utilities;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.regex.Pattern;

public class McHelper {
    private static int GetReadWordLength(McType type) {
        if (type == McType.McBinary) {
            return 950;
        }
        return 460;
    }

    private static int GetReadBoolLength(McType type) {
        if (type == McType.McBinary) {
            return 7168;
        }
        return 3584;
    }

    public static OperateResultExOne<byte[]> Read(IReadWriteMc mc, String address, short length) {
        int readLength;
        if (mc.getMcType() == McType.McBinary && address.startsWith("s=") || address.startsWith("S=")) {
            return McBinaryHelper.ReadTags(mc, new String[]{address.substring(2)}, new short[]{length});
        }
        if ((mc.getMcType() == McType.McBinary || mc.getMcType() == McType.MCAscii) && Pattern.matches("ext=[0-9]+;", address)) {
            String extStr = Pattern.compile("ext=[0-9]+;").matcher(address).group();
            short ext = Short.parseShort(Pattern.compile("[0-9]+").matcher(extStr).group());
            return McHelper.ReadExtend(mc, ext, address.substring(extStr.length()), (short)length);
        }
        if ((mc.getMcType() == McType.McBinary || mc.getMcType() == McType.MCAscii) && Pattern.matches("mem=", address)) {
            return McHelper.ReadMemory(mc, address.substring(4), (short)length);
        }
        OperateResultExOne<McAddressData> addressResult = mc.McAnalysisAddress(address, (short)length);
        if (!addressResult.IsSuccess) {
            return OperateResultExOne.CreateFailedResult(addressResult);
        }
        ArrayList<Byte> bytesContent = new ArrayList<Byte>();
        for (int alreadyFinished = 0; alreadyFinished < length; alreadyFinished += readLength) {
            readLength = Math.min(length - alreadyFinished, McHelper.GetReadWordLength(mc.getMcType()));
            ((McAddressData)addressResult.Content).setLength(readLength);
            byte[] command = mc.getMcType() == McType.McBinary ? McBinaryHelper.BuildReadMcCoreCommand((McAddressData)addressResult.Content, false) : (byte[])(mc.getMcType() == McType.MCAscii ? McAsciiHelper.BuildAsciiReadMcCoreCommand((McAddressData)addressResult.Content, false) : null);
            OperateResultExOne<byte[]> read = mc.ReadFromCoreServer(command);
            if (!read.IsSuccess) {
                return read;
            }
            Utilities.ArrayListAddArray(bytesContent, mc.ExtractActualData((byte[])read.Content, false));
            if (((McAddressData)addressResult.Content).getMcDataType().getDataType() == 0) {
                ((McAddressData)addressResult.Content).setAddressStart(((McAddressData)addressResult.Content).getAddressStart() + readLength);
                continue;
            }
            ((McAddressData)addressResult.Content).setAddressStart(((McAddressData)addressResult.Content).getAddressStart() + readLength * 16);
        }
        return OperateResultExOne.CreateSuccessResult(Utilities.getBytes(bytesContent));
    }

    public static OperateResult Write(IReadWriteMc mc, String address, byte[] value) {
        OperateResultExOne<McAddressData> addressResult = mc.McAnalysisAddress(address, (short)0);
        if (!addressResult.IsSuccess) {
            return OperateResultExOne.CreateFailedResult(addressResult);
        }
        byte[] coreResult = mc.getMcType() == McType.McBinary ? McBinaryHelper.BuildWriteWordCoreCommand((McAddressData)addressResult.Content, value) : (byte[])(mc.getMcType() == McType.MCAscii ? McAsciiHelper.BuildAsciiWriteWordCoreCommand((McAddressData)addressResult.Content, value) : null);
        OperateResultExOne<byte[]> read = mc.ReadFromCoreServer(coreResult);
        if (!read.IsSuccess) {
            return read;
        }
        return OperateResult.CreateSuccessResult();
    }

    public static OperateResultExOne<boolean[]> ReadBool(IReadWriteMc mc, String address, short length) {
        if (address.indexOf(46) > 0) {
            String[] addressSplits = address.split("\\.");
            int bitIndex = 0;
            try {
                bitIndex = Integer.parseInt(addressSplits[1]);
            }
            catch (Exception ex) {
                return new OperateResultExOne<boolean[]>("Bit Index format wrong, " + ex.getMessage());
            }
            short len = (short)((length + bitIndex + 15) / 16);
            OperateResultExOne<byte[]> read = mc.Read(addressSplits[0], len);
            if (!read.IsSuccess) {
                return OperateResultExOne.CreateFailedResult(read);
            }
            return OperateResultExOne.CreateSuccessResult(SoftBasic.BoolArraySelectMiddle(SoftBasic.ByteToBoolArray((byte[])read.Content), bitIndex, length));
        }
        OperateResultExOne<McAddressData> addressResult = mc.McAnalysisAddress(address, length);
        if (!addressResult.IsSuccess) {
            return OperateResultExOne.CreateFailedResult(addressResult);
        }
        ArrayList<Boolean> boolContent = new ArrayList<Boolean>();
        short alreadyFinished = 0;
        while (alreadyFinished < length) {
            int readLength = Math.min(length - alreadyFinished, McHelper.GetReadBoolLength(mc.getMcType()));
            ((McAddressData)addressResult.Content).setLength(readLength);
            byte[] coreResult = mc.getMcType() == McType.McBinary ? McBinaryHelper.BuildReadMcCoreCommand((McAddressData)addressResult.Content, true) : (byte[])(mc.getMcType() == McType.MCAscii ? McAsciiHelper.BuildAsciiReadMcCoreCommand((McAddressData)addressResult.Content, true) : null);
            OperateResultExOne<byte[]> read = mc.ReadFromCoreServer(coreResult);
            if (!read.IsSuccess) {
                return OperateResultExOne.CreateFailedResult(read);
            }
            byte[] extra = mc.ExtractActualData((byte[])read.Content, true);
            for (int i = 0; i < readLength; ++i) {
                if (i >= extra.length) continue;
                boolContent.add(extra[i] == 1);
            }
            alreadyFinished = (short)(alreadyFinished + readLength);
            ((McAddressData)addressResult.Content).setAddressStart(((McAddressData)addressResult.Content).getAddressStart() + readLength);
        }
        return OperateResultExOne.CreateSuccessResult(Utilities.ToBoolArray(boolContent));
    }

    public static OperateResult Write(IReadWriteMc mc, String address, boolean[] values) {
        OperateResultExOne<McAddressData> addressResult = mc.McAnalysisAddress(address, (short)0);
        if (!addressResult.IsSuccess) {
            return addressResult;
        }
        byte[] coreResult = mc.getMcType() == McType.McBinary ? McBinaryHelper.BuildWriteBitCoreCommand((McAddressData)addressResult.Content, values) : (byte[])(mc.getMcType() == McType.MCAscii ? McAsciiHelper.BuildAsciiWriteBitCoreCommand((McAddressData)addressResult.Content, values) : null);
        OperateResultExOne<byte[]> read = mc.ReadFromCoreServer(coreResult);
        if (!read.IsSuccess) {
            return read;
        }
        return OperateResult.CreateSuccessResult();
    }

    public static OperateResultExOne<byte[]> ReadRandom(IReadWriteMc mc, String[] address) {
        McAddressData[] mcAddressDatas = new McAddressData[address.length];
        for (int i = 0; i < address.length; ++i) {
            OperateResultExOne<McAddressData> addressResult = McAddressData.ParseMelsecFrom(address[i], 1);
            if (!addressResult.IsSuccess) {
                return OperateResultExOne.CreateFailedResult(addressResult);
            }
            mcAddressDatas[i] = (McAddressData)addressResult.Content;
        }
        byte[] coreResult = mc.getMcType() == McType.McBinary ? McBinaryHelper.BuildReadRandomWordCommand(mcAddressDatas) : (byte[])(mc.getMcType() == McType.MCAscii ? McAsciiHelper.BuildAsciiReadRandomWordCommand(mcAddressDatas) : null);
        OperateResultExOne<byte[]> read = mc.ReadFromCoreServer(coreResult);
        if (!read.IsSuccess) {
            return OperateResultExOne.CreateFailedResult(read);
        }
        return OperateResultExOne.CreateSuccessResult(mc.ExtractActualData((byte[])read.Content, false));
    }

    public static OperateResultExOne<byte[]> ReadRandom(IReadWriteMc mc, String[] address, short[] length) {
        if (length.length != address.length) {
            return new OperateResultExOne<byte[]>(StringResources.Language.TwoParametersLengthIsNotSame());
        }
        McAddressData[] mcAddressDatas = new McAddressData[address.length];
        for (int i = 0; i < address.length; ++i) {
            OperateResultExOne<McAddressData> addressResult = McAddressData.ParseMelsecFrom(address[i], length[i]);
            if (!addressResult.IsSuccess) {
                return OperateResultExOne.CreateFailedResult(addressResult);
            }
            mcAddressDatas[i] = (McAddressData)addressResult.Content;
        }
        byte[] coreResult = mc.getMcType() == McType.McBinary ? McBinaryHelper.BuildReadRandomCommand(mcAddressDatas) : (byte[])(mc.getMcType() == McType.MCAscii ? McAsciiHelper.BuildAsciiReadRandomCommand(mcAddressDatas) : null);
        OperateResultExOne<byte[]> read = mc.ReadFromCoreServer(coreResult);
        if (!read.IsSuccess) {
            return OperateResultExOne.CreateFailedResult(read);
        }
        return OperateResultExOne.CreateSuccessResult(mc.ExtractActualData((byte[])read.Content, false));
    }

    public static OperateResultExOne<short[]> ReadRandomInt16(IReadWriteMc mc, String[] address) {
        OperateResultExOne<byte[]> read = McHelper.ReadRandom(mc, address);
        if (!read.IsSuccess) {
            return OperateResultExOne.CreateFailedResult(read);
        }
        return OperateResultExOne.CreateSuccessResult(mc.getByteTransform().TransInt16((byte[])read.Content, 0, address.length));
    }

    public static OperateResultExOne<int[]> ReadRandomUInt16(IReadWriteMc mc, String[] address) {
        OperateResultExOne<byte[]> read = McHelper.ReadRandom(mc, address);
        if (!read.IsSuccess) {
            return OperateResultExOne.CreateFailedResult(read);
        }
        return OperateResultExOne.CreateSuccessResult(mc.getByteTransform().TransUInt16((byte[])read.Content, 0, address.length));
    }

    public static OperateResultExOne<byte[]> ReadMemory(IReadWriteMc mc, String address, short length) {
        OperateResultExOne<byte[]> coreResult;
        if (!Authorization.asdniasnfaksndiqwhawfskhfaiw()) {
            return new OperateResultExOne<byte[]>(StringResources.Language.InsufficientPrivileges());
        }
        OperateResultExOne<Object> operateResultExOne = mc.getMcType() == McType.McBinary ? McBinaryHelper.BuildReadMemoryCommand(address, length) : (coreResult = mc.getMcType() == McType.MCAscii ? McAsciiHelper.BuildAsciiReadMemoryCommand(address, length) : null);
        if (!coreResult.IsSuccess) {
            return coreResult;
        }
        OperateResultExOne<byte[]> read = mc.ReadFromCoreServer((byte[])coreResult.Content);
        if (!read.IsSuccess) {
            return OperateResultExOne.CreateFailedResult(read);
        }
        return OperateResultExOne.CreateSuccessResult(mc.ExtractActualData((byte[])read.Content, false));
    }

    public static OperateResultExOne<byte[]> ReadSmartModule(IReadWriteMc mc, short module, String address, short length) {
        OperateResultExOne<byte[]> coreResult;
        if (!Authorization.asdniasnfaksndiqwhawfskhfaiw()) {
            return new OperateResultExOne<byte[]>(StringResources.Language.InsufficientPrivileges());
        }
        OperateResultExOne<Object> operateResultExOne = mc.getMcType() == McType.McBinary ? McBinaryHelper.BuildReadSmartModule(module, address, length) : (coreResult = mc.getMcType() == McType.MCAscii ? McAsciiHelper.BuildAsciiReadSmartModule(module, address, length) : null);
        if (!coreResult.IsSuccess) {
            return coreResult;
        }
        OperateResultExOne<byte[]> read = mc.ReadFromCoreServer((byte[])coreResult.Content);
        if (!read.IsSuccess) {
            return OperateResultExOne.CreateFailedResult(read);
        }
        return OperateResultExOne.CreateSuccessResult(mc.ExtractActualData((byte[])read.Content, false));
    }

    public static OperateResultExOne<byte[]> ReadExtend(IReadWriteMc mc, short extend, String address, short length) {
        if (!Authorization.asdniasnfaksndiqwhawfskhfaiw()) {
            return new OperateResultExOne<byte[]>(StringResources.Language.InsufficientPrivileges());
        }
        OperateResultExOne<McAddressData> addressResult = mc.McAnalysisAddress(address, length);
        if (!addressResult.IsSuccess) {
            return OperateResultExOne.CreateFailedResult(addressResult);
        }
        byte[] coreResult = mc.getMcType() == McType.McBinary ? McBinaryHelper.BuildReadMcCoreExtendCommand((McAddressData)addressResult.Content, extend, false) : (mc.getMcType() == McType.MCAscii ? McAsciiHelper.BuildAsciiReadMcCoreExtendCommand((McAddressData)addressResult.Content, extend, false) : null);
        OperateResultExOne<byte[]> read = mc.ReadFromCoreServer(coreResult);
        if (!read.IsSuccess) {
            return OperateResultExOne.CreateFailedResult(read);
        }
        return OperateResultExOne.CreateSuccessResult(mc.ExtractActualData((byte[])read.Content, false));
    }

    public static OperateResult RemoteRun(IReadWriteMc mc) {
        return mc.getMcType() == McType.McBinary ? mc.ReadFromCoreServer(new byte[]{1, 16, 0, 0, 1, 0, 0, 0}) : (mc.getMcType() == McType.MCAscii ? mc.ReadFromCoreServer("1001000000010000".getBytes(StandardCharsets.US_ASCII)) : new OperateResultExOne<byte[]>(StringResources.Language.NotSupportedFunction()));
    }

    public static OperateResult RemoteStop(IReadWriteMc mc) {
        return mc.getMcType() == McType.McBinary ? mc.ReadFromCoreServer(new byte[]{2, 16, 0, 0, 1, 0}) : (mc.getMcType() == McType.MCAscii ? mc.ReadFromCoreServer("100200000001".getBytes(StandardCharsets.US_ASCII)) : new OperateResultExOne<byte[]>(StringResources.Language.NotSupportedFunction()));
    }

    public static OperateResult RemoteReset(IReadWriteMc mc) {
        return mc.getMcType() == McType.McBinary ? mc.ReadFromCoreServer(new byte[]{6, 16, 0, 0, 1, 0}) : (mc.getMcType() == McType.MCAscii ? mc.ReadFromCoreServer("100600000001".getBytes(StandardCharsets.US_ASCII)) : new OperateResultExOne<byte[]>(StringResources.Language.NotSupportedFunction()));
    }

    public static OperateResultExOne<String> ReadPlcType(IReadWriteMc mc) {
        OperateResultExOne<byte[]> read;
        OperateResultExOne<byte[]> operateResultExOne = mc.getMcType() == McType.McBinary ? mc.ReadFromCoreServer(new byte[]{1, 1, 0, 0}) : (read = mc.getMcType() == McType.MCAscii ? mc.ReadFromCoreServer("01010000".getBytes(StandardCharsets.US_ASCII)) : new OperateResultExOne<byte[]>(StringResources.Language.NotSupportedFunction()));
        if (!read.IsSuccess) {
            return OperateResultExOne.CreateFailedResult(read);
        }
        return OperateResultExOne.CreateSuccessResult(new String((byte[])read.Content, 0, 16, StandardCharsets.US_ASCII).trim());
    }

    public static OperateResult ErrorStateReset(IReadWriteMc mc) {
        return mc.getMcType() == McType.McBinary ? mc.ReadFromCoreServer(new byte[]{23, 22, 0, 0}) : (mc.getMcType() == McType.MCAscii ? mc.ReadFromCoreServer("16170000".getBytes(StandardCharsets.US_ASCII)) : new OperateResultExOne<byte[]>(StringResources.Language.NotSupportedFunction()));
    }
}

