/*
 * Decompiled with CFR 0.152.
 */
package com.github.houbb.heaven.util.lang.reflect;

import com.github.houbb.heaven.annotation.reflect.Param;
import com.github.houbb.heaven.response.exception.CommonRuntimeException;
import com.github.houbb.heaven.support.handler.IHandler;
import com.github.houbb.heaven.util.common.ArgUtil;
import com.github.houbb.heaven.util.guava.Guavas;
import com.github.houbb.heaven.util.lang.ObjectUtil;
import com.github.houbb.heaven.util.lang.StringUtil;
import com.github.houbb.heaven.util.lang.reflect.ClassUtil;
import com.github.houbb.heaven.util.lang.reflect.TypeUtil;
import com.github.houbb.heaven.util.util.ArrayUtil;
import com.github.houbb.heaven.util.util.Optional;
import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;

public final class ReflectMethodUtil {
    private static final List<String> IGNORE_METHOD_LIST;

    private ReflectMethodUtil() {
    }

    public static List<String> getIgnoreMethodList() {
        return IGNORE_METHOD_LIST;
    }

    public static boolean isIgnoreMethod(String methodName) {
        return ReflectMethodUtil.getIgnoreMethodList().contains(methodName);
    }

    public static List<String> getParamTypeNames(Method method) {
        ArgUtil.notNull(method, "method");
        Class<?>[] paramTypes = method.getParameterTypes();
        return ArrayUtil.toList(paramTypes, new IHandler<Class<?>, String>(){

            @Override
            public String handle(Class<?> aClass) {
                return aClass.getName();
            }
        });
    }

    public static List<String> getParamNames(Method method) {
        ArgUtil.notNull(method, "method");
        Annotation[][] parameterAnnotations = method.getParameterAnnotations();
        return ReflectMethodUtil.getParamNames(parameterAnnotations);
    }

    public static List<String> getParamNames(Annotation[][] parameterAnnotations) {
        if (ArrayUtil.isEmpty((Object[])parameterAnnotations)) {
            return Collections.emptyList();
        }
        int paramSize = parameterAnnotations.length;
        List<String> resultList = Guavas.newArrayList(paramSize);
        for (int i = 0; i < paramSize; ++i) {
            Annotation[] annotations = parameterAnnotations[i];
            String paramName = ReflectMethodUtil.getParamName(i, annotations);
            resultList.add(paramName);
        }
        return resultList;
    }

    private static String getParamName(int index, Annotation[] annotations) {
        String defaultName = "arg" + index;
        if (ArrayUtil.isEmpty(annotations)) {
            return defaultName;
        }
        for (Annotation annotation : annotations) {
            if (!annotation.annotationType().equals(Param.class)) continue;
            Param param = (Param)annotation;
            return param.value();
        }
        return defaultName;
    }

    public static Class getReturnGenericType(Method method, int index) {
        Type returnType = method.getGenericReturnType();
        if (returnType instanceof ParameterizedType) {
            ParameterizedType type = (ParameterizedType)returnType;
            Type[] typeArguments = type.getActualTypeArguments();
            return (Class)typeArguments[index];
        }
        return null;
    }

    public static Class getParamGenericType(Method method, int paramIndex, int genericIndex) {
        Type[] genericParameterTypes = method.getGenericParameterTypes();
        Type genericParameterType = genericParameterTypes[paramIndex];
        if (genericParameterType instanceof ParameterizedType) {
            ParameterizedType aType = (ParameterizedType)genericParameterType;
            Type[] parameterArgTypes = aType.getActualTypeArguments();
            return (Class)parameterArgTypes[genericIndex];
        }
        return null;
    }

    public static Optional<Method> getMethodOptional(Class tClass, Class<? extends Annotation> annotationClass) {
        Object[] methods = tClass.getMethods();
        if (ArrayUtil.isEmpty(methods)) {
            return Optional.empty();
        }
        for (Object method : methods) {
            if (!((AccessibleObject)method).isAnnotationPresent(annotationClass)) continue;
            return Optional.of(method);
        }
        return Optional.empty();
    }

    public static Object invoke(Object instance, Method method, Object ... args) {
        ArgUtil.notNull(method, "method");
        try {
            return method.invoke(instance, args);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new CommonRuntimeException(e);
        }
    }

    public static Object invoke(Object instance, String methodName, Object ... args) {
        ArgUtil.notEmpty(methodName, "methodName");
        try {
            if (ArrayUtil.isEmpty(args)) {
                return ReflectMethodUtil.invokeNoArgsMethod(instance, methodName);
            }
            Class<?> clazz = instance.getClass();
            Class[] paramTypes = new Class[args.length];
            for (int i = 0; i < args.length; ++i) {
                Object param = args[i];
                paramTypes[i] = param.getClass();
            }
            Method method = ClassUtil.getMethod(clazz, methodName, paramTypes);
            return method.invoke(instance, args);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new CommonRuntimeException(e);
        }
    }

    public static Object invokeNoArgsMethod(Object instance, Method method) {
        if (ObjectUtil.isNull(method)) {
            return null;
        }
        String methodName = method.getName();
        Object[] paramTypes = method.getParameterTypes();
        if (ArrayUtil.isNotEmpty(paramTypes)) {
            throw new CommonRuntimeException(methodName + " must be has no params.");
        }
        return ReflectMethodUtil.invoke(instance, method, new Object[0]);
    }

    public static Object invokeNoArgsMethod(Object instance, String methodName) {
        ArgUtil.notNull(instance, "instance");
        Class<?> clazz = instance.getClass();
        Method method = ClassUtil.getMethod(clazz, methodName);
        return ReflectMethodUtil.invokeNoArgsMethod(instance, method);
    }

    public static Object invokeFactoryMethod(Class clazz, Method factoryMethod) {
        ArgUtil.notNull(clazz, "clazz");
        ArgUtil.notNull(factoryMethod, "factoryMethod");
        String methodName = factoryMethod.getName();
        Object[] paramTypes = factoryMethod.getParameterTypes();
        if (ArrayUtil.isNotEmpty(paramTypes)) {
            throw new CommonRuntimeException(methodName + " must be has no params.");
        }
        if (!Modifier.isStatic(factoryMethod.getModifiers())) {
            throw new CommonRuntimeException(methodName + " must be static.");
        }
        Class<?> returnType = factoryMethod.getReturnType();
        if (!returnType.isAssignableFrom(clazz)) {
            throw new CommonRuntimeException(methodName + " must be return " + returnType.getName());
        }
        return ReflectMethodUtil.invoke(null, factoryMethod, new Object[0]);
    }

    public static Class getGenericReturnParamType(Method method, int paramIndex) {
        ArgUtil.notNull(method, "method");
        ArgUtil.notNegative(paramIndex, "paramIndex");
        Type returnType = method.getGenericReturnType();
        if (ObjectUtil.isNull(returnType)) {
            return null;
        }
        return TypeUtil.getGenericParamType(returnType, paramIndex);
    }

    public static void invokeSetterMethod(Object instance, String propertyName, Object value) {
        ArgUtil.notNull(instance, "instance");
        ArgUtil.notNull(propertyName, "propertyName");
        if (ObjectUtil.isNull(value)) {
            return;
        }
        Class<?> clazz = instance.getClass();
        String setMethodName = ReflectMethodUtil.buildSetMethodName(propertyName);
        Class<?> paramType = value.getClass();
        try {
            Method method = clazz.getMethod(setMethodName, paramType);
            method.invoke(instance, value);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new CommonRuntimeException(e);
        }
    }

    public static Object invokeGetterMethod(Object instance, String fieldName, Class fieldType) {
        ArgUtil.notNull(instance, "instance");
        ArgUtil.notNull(fieldType, "fieldType");
        ArgUtil.notEmpty(fieldName, "fieldName");
        Class<?> clazz = instance.getClass();
        String getMethodName = ReflectMethodUtil.buildGetMethodName(fieldType, fieldName);
        try {
            Method method = clazz.getMethod(getMethodName, new Class[0]);
            return method.invoke(instance, new Object[0]);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new CommonRuntimeException(e);
        }
    }

    public static Object invokeGetterMethod(Object instance, String fieldName) {
        return ReflectMethodUtil.invokeGetterMethod(instance, fieldName, String.class);
    }

    public static Object invokeGetterMethod(Object instance, Field field) {
        Class<?> fieldType = field.getType();
        String fieldName = field.getName();
        return ReflectMethodUtil.invokeGetterMethod(instance, fieldName, fieldType);
    }

    public static String buildSetMethodName(String propertyName) {
        ArgUtil.notEmpty(propertyName, "propertyName");
        return "set" + StringUtil.firstToUpperCase(propertyName);
    }

    public static String buildGetMethodName(Class fieldType, String propertyName) {
        ArgUtil.notNull(fieldType, "fieldType");
        ArgUtil.notEmpty(propertyName, "propertyName");
        if (Boolean.TYPE.equals(fieldType)) {
            return "is" + StringUtil.firstToUpperCase(propertyName);
        }
        return "get" + StringUtil.firstToUpperCase(propertyName);
    }

    public static String buildGetMethodName(String propertyName) {
        return ReflectMethodUtil.buildGetMethodName(String.class, propertyName);
    }

    static {
        HashSet<String> methodNameSet = new HashSet<String>(64);
        for (Method method : Object.class.getMethods()) {
            methodNameSet.add(method.getName());
        }
        for (Method method : Class.class.getMethods()) {
            methodNameSet.add(method.getName());
        }
        IGNORE_METHOD_LIST = new ArrayList<String>(methodNameSet);
    }
}

