/*
 * Decompiled with CFR 0.152.
 */
package com.github.houbb.sensitive.word.support.check.impl;

import com.github.houbb.heaven.annotation.ThreadSafe;
import com.github.houbb.heaven.support.instance.impl.Instances;
import com.github.houbb.heaven.util.lang.CharUtil;
import com.github.houbb.heaven.util.util.regex.RegexUtil;
import com.github.houbb.sensitive.word.api.IWordContext;
import com.github.houbb.sensitive.word.constant.enums.ValidModeEnum;
import com.github.houbb.sensitive.word.support.check.ISensitiveCheck;
import com.github.houbb.sensitive.word.support.check.SensitiveCheckResult;
import com.github.houbb.sensitive.word.support.format.CharFormatChain;

@ThreadSafe
public class SensitiveCheckUrl
implements ISensitiveCheck {
    private static final int MAX_WEB_SITE_LEN = 70;

    @Override
    public SensitiveCheckResult sensitiveCheck(String txt, int beginIndex, ValidModeEnum validModeEnum, IWordContext context) {
        int lengthCount = 0;
        int actualLength = 0;
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = beginIndex; i < txt.length(); ++i) {
            char currentChar = txt.charAt(i);
            char mappingChar = ((CharFormatChain)Instances.singleton(CharFormatChain.class)).format(currentChar, context);
            if (!CharUtil.isWebSiteChar((char)mappingChar) || lengthCount > 70) break;
            ++lengthCount;
            stringBuilder.append(currentChar);
            if (!this.isCondition(stringBuilder.toString())) continue;
            actualLength = lengthCount;
            if (ValidModeEnum.FAIL_FAST.equals((Object)validModeEnum)) break;
        }
        return SensitiveCheckResult.of(actualLength, SensitiveCheckUrl.class);
    }

    private boolean isCondition(String string) {
        return RegexUtil.isWebSite((String)string);
    }
}

