/*
 * Decompiled with CFR 0.152.
 */
package com.github.houbb.sensitive.word.support.format;

import com.github.houbb.heaven.annotation.ThreadSafe;
import com.github.houbb.heaven.support.instance.impl.Instances;
import com.github.houbb.heaven.util.guava.Guavas;
import com.github.houbb.sensitive.word.api.ICharFormat;
import com.github.houbb.sensitive.word.api.IWordContext;
import com.github.houbb.sensitive.word.support.format.IgnoreCaseCharFormat;
import com.github.houbb.sensitive.word.support.format.IgnoreChineseStyleFormat;
import com.github.houbb.sensitive.word.support.format.IgnoreEnglishStyleFormat;
import com.github.houbb.sensitive.word.support.format.IgnoreNumStyleCharFormat;
import com.github.houbb.sensitive.word.support.format.IgnoreWidthCharFormat;
import java.util.List;

@ThreadSafe
public class CharFormatChain
implements ICharFormat {
    @Override
    public char format(char original, IWordContext context) {
        char result = original;
        List charFormats = Guavas.newArrayList();
        if (context.ignoreEnglishStyle()) {
            charFormats.add(Instances.singleton(IgnoreEnglishStyleFormat.class));
        }
        if (context.ignoreCase()) {
            charFormats.add(Instances.singleton(IgnoreCaseCharFormat.class));
        }
        if (context.ignoreWidth()) {
            charFormats.add(Instances.singleton(IgnoreWidthCharFormat.class));
        }
        if (context.ignoreNumStyle()) {
            charFormats.add(Instances.singleton(IgnoreNumStyleCharFormat.class));
        }
        if (context.ignoreChineseStyle()) {
            charFormats.add(Instances.singleton(IgnoreChineseStyleFormat.class));
        }
        for (ICharFormat charFormat : charFormats) {
            result = charFormat.format(result, context);
        }
        return result;
    }
}

