/*
 * Decompiled with CFR 0.152.
 */
package com.github.houbb.sensitive.word.support.map;

import com.github.houbb.heaven.annotation.ThreadSafe;
import com.github.houbb.heaven.support.instance.impl.Instances;
import com.github.houbb.heaven.util.guava.Guavas;
import com.github.houbb.heaven.util.io.FileUtil;
import com.github.houbb.heaven.util.lang.ObjectUtil;
import com.github.houbb.heaven.util.lang.StringUtil;
import com.github.houbb.heaven.util.util.CollectionUtil;
import com.github.houbb.sensitive.word.api.ISensitiveWordReplace;
import com.github.houbb.sensitive.word.api.IWordContext;
import com.github.houbb.sensitive.word.api.IWordMap;
import com.github.houbb.sensitive.word.api.IWordResult;
import com.github.houbb.sensitive.word.constant.enums.ValidModeEnum;
import com.github.houbb.sensitive.word.support.check.ISensitiveCheck;
import com.github.houbb.sensitive.word.support.check.SensitiveCheckResult;
import com.github.houbb.sensitive.word.support.check.impl.SensitiveCheckChain;
import com.github.houbb.sensitive.word.support.check.impl.SensitiveCheckUrl;
import com.github.houbb.sensitive.word.support.replace.SensitiveWordReplaceContext;
import com.github.houbb.sensitive.word.support.result.WordResult;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@ThreadSafe
public class SensitiveWordMap
implements IWordMap {
    private Map innerWordMap;

    @Override
    public synchronized void initWordMap(Collection<String> collection) {
        long startTime = System.currentTimeMillis();
        HashMap newInnerWordMap = new HashMap(collection.size());
        for (String key : collection) {
            if (StringUtil.isEmpty((String)key)) continue;
            char[] chars = key.toCharArray();
            int size = chars.length;
            Map<Object, Serializable> currentMap = newInnerWordMap;
            for (int i = 0; i < size; ++i) {
                char charKey = chars[i];
                Object wordMap = currentMap.get(Character.valueOf(charKey));
                if (ObjectUtil.isNotNull(wordMap)) {
                    currentMap = (Map)wordMap;
                } else {
                    HashMap<String, Boolean> newWordMap = new HashMap<String, Boolean>(8);
                    newWordMap.put("ED", false);
                    currentMap.put(Character.valueOf(charKey), newWordMap);
                    currentMap = newWordMap;
                }
                if (i != size - 1) continue;
                currentMap.put("ED", Boolean.valueOf(true));
            }
        }
        this.innerWordMap = newInnerWordMap;
        long endTime = System.currentTimeMillis();
    }

    @Override
    public boolean contains(String string, IWordContext context) {
        if (StringUtil.isEmpty((String)string)) {
            return false;
        }
        for (int i = 0; i < string.length(); ++i) {
            SensitiveCheckResult checkResult = this.sensitiveCheck(string, i, ValidModeEnum.FAIL_FAST, context);
            if (checkResult.index() <= 0) continue;
            return true;
        }
        return false;
    }

    @Override
    public List<IWordResult> findAll(String string, IWordContext context) {
        return this.getSensitiveWords(string, ValidModeEnum.FAIL_OVER, context);
    }

    @Override
    public IWordResult findFirst(String string, IWordContext context) {
        List<IWordResult> stringList = this.getSensitiveWords(string, ValidModeEnum.FAIL_FAST, context);
        if (CollectionUtil.isEmpty(stringList)) {
            return null;
        }
        return stringList.get(0);
    }

    @Override
    public String replace(String target, ISensitiveWordReplace replace, IWordContext context) {
        if (StringUtil.isEmpty((String)target)) {
            return target;
        }
        return this.replaceSensitiveWord(target, replace, context);
    }

    private List<IWordResult> getSensitiveWords(String text, ValidModeEnum modeEnum, IWordContext context) {
        if (StringUtil.isEmpty((String)text)) {
            return Guavas.newArrayList();
        }
        List resultList = Guavas.newArrayList();
        for (int i = 0; i < text.length(); ++i) {
            SensitiveCheckResult checkResult = this.sensitiveCheck(text, i, ValidModeEnum.FAIL_OVER, context);
            int wordLength = checkResult.index();
            if (wordLength <= 0) continue;
            String sensitiveWord = text.substring(i, i + wordLength);
            WordResult wordResult = WordResult.newInstance().startIndex(i).endIndex(i + wordLength).word(sensitiveWord);
            resultList.add(wordResult);
            if (ValidModeEnum.FAIL_FAST.equals((Object)modeEnum)) break;
            i += wordLength - 1;
        }
        return resultList;
    }

    private String replaceSensitiveWord(String target, ISensitiveWordReplace replace, IWordContext context) {
        if (StringUtil.isEmpty((String)target)) {
            return target;
        }
        StringBuilder resultBuilder = new StringBuilder(target.length());
        for (int i = 0; i < target.length(); ++i) {
            char currentChar = target.charAt(i);
            SensitiveCheckResult checkResult = this.sensitiveCheck(target, i, ValidModeEnum.FAIL_OVER, context);
            int wordLength = checkResult.index();
            if (wordLength > 0) {
                Class<? extends ISensitiveCheck> checkClass = checkResult.checkClass();
                String string = target.substring(i, i + wordLength);
                if (SensitiveCheckUrl.class.equals(checkClass) && FileUtil.isImage((String)string)) {
                    resultBuilder.append(string);
                } else {
                    SensitiveWordReplaceContext replaceContext = SensitiveWordReplaceContext.newInstance().sensitiveWord(string).wordLength(wordLength);
                    String replaceStr = replace.replace(replaceContext);
                    resultBuilder.append(replaceStr);
                }
                i += wordLength - 1;
                continue;
            }
            resultBuilder.append(currentChar);
        }
        return resultBuilder.toString();
    }

    @Override
    public SensitiveCheckResult sensitiveCheck(String txt, int beginIndex, ValidModeEnum validModeEnum, IWordContext context) {
        context.sensitiveWordMap(this.innerWordMap);
        return ((SensitiveCheckChain)Instances.singleton(SensitiveCheckChain.class)).sensitiveCheck(txt, beginIndex, validModeEnum, context);
    }
}

