/*
 * Decompiled with CFR 0.152.
 */
package com.github.housepower.client;

import com.github.housepower.client.NativeClient;
import com.github.housepower.serde.BinarySerializer;
import com.github.housepower.settings.ClickHouseConfig;
import java.io.IOException;
import java.time.ZoneId;

public class NativeContext {
    private final ClientContext clientCtx;
    private final ServerContext serverCtx;
    private final NativeClient nativeClient;

    public NativeContext(ClientContext clientCtx, ServerContext serverCtx, NativeClient nativeClient) {
        this.clientCtx = clientCtx;
        this.serverCtx = serverCtx;
        this.nativeClient = nativeClient;
    }

    public ClientContext clientCtx() {
        return this.clientCtx;
    }

    public ServerContext serverCtx() {
        return this.serverCtx;
    }

    public NativeClient nativeClient() {
        return this.nativeClient;
    }

    public static class ServerContext {
        private final long majorVersion;
        private final long minorVersion;
        private final long reversion;
        private final ZoneId timeZone;
        private final String displayName;
        private final ClickHouseConfig configure;

        public ServerContext(long majorVersion, long minorVersion, long reversion, ClickHouseConfig configure, ZoneId timeZone, String displayName) {
            this.majorVersion = majorVersion;
            this.minorVersion = minorVersion;
            this.reversion = reversion;
            this.configure = configure;
            this.timeZone = timeZone;
            this.displayName = displayName;
        }

        public long majorVersion() {
            return this.majorVersion;
        }

        public long minorVersion() {
            return this.minorVersion;
        }

        public long reversion() {
            return this.reversion;
        }

        public String version() {
            return this.majorVersion + "." + this.minorVersion + "." + this.reversion;
        }

        public ZoneId timeZone() {
            return this.timeZone;
        }

        public String displayName() {
            return this.displayName;
        }

        public ClickHouseConfig getConfigure() {
            return this.configure;
        }
    }

    public static class ClientContext {
        public static final int TCP_KINE = 1;
        public static final byte NO_QUERY = 0;
        public static final byte INITIAL_QUERY = 1;
        public static final byte SECONDARY_QUERY = 2;
        private final String clientName;
        private final String clientHostname;
        private final String initialAddress;

        public ClientContext(String initialAddress, String clientHostname, String clientName) {
            this.clientName = clientName;
            this.clientHostname = clientHostname;
            this.initialAddress = initialAddress;
        }

        public void writeTo(BinarySerializer serializer) throws IOException {
            serializer.writeVarInt(1L);
            serializer.writeUTF8StringBinary("");
            serializer.writeUTF8StringBinary("");
            serializer.writeUTF8StringBinary(this.initialAddress);
            serializer.writeVarInt(1L);
            serializer.writeUTF8StringBinary("");
            serializer.writeUTF8StringBinary(this.clientHostname);
            serializer.writeUTF8StringBinary(this.clientName);
            serializer.writeVarInt(1L);
            serializer.writeVarInt(1L);
            serializer.writeVarInt(54380L);
            serializer.writeUTF8StringBinary("");
        }
    }
}

