/*
 * Decompiled with CFR 0.152.
 */
package com.github.housepower.data;

import com.github.housepower.data.AbstractColumn;
import com.github.housepower.data.ColumnFactory;
import com.github.housepower.data.ColumnWriterBuffer;
import com.github.housepower.data.IColumn;
import com.github.housepower.data.IDataType;
import com.github.housepower.data.type.complex.DataTypeMap;
import com.github.housepower.serde.BinarySerializer;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class ColumnMap
extends AbstractColumn {
    private final IColumn[] columnDataArray;
    private final List<Long> offsets = new ArrayList<Long>();

    public ColumnMap(String name, DataTypeMap type, Object[] values) {
        super(name, type, values);
        IDataType[] types = type.getNestedTypes();
        this.columnDataArray = new IColumn[types.length];
        for (int i = 0; i < types.length; ++i) {
            this.columnDataArray[i] = ColumnFactory.createColumn(null, types[i], null);
        }
    }

    @Override
    public void write(Object object) throws IOException, SQLException {
        if (object instanceof Map) {
            Map dataMap = (Map)object;
            this.offsets.add(this.offsets.isEmpty() ? (long)dataMap.size() : this.offsets.get(this.offsets.size() - 1) + (long)dataMap.size());
            for (Object key : dataMap.keySet()) {
                this.columnDataArray[0].write(key);
            }
            for (Object value : dataMap.values()) {
                this.columnDataArray[1].write(value);
            }
        }
    }

    @Override
    public void flushToSerializer(BinarySerializer serializer, boolean now) throws IOException, SQLException {
        if (this.isExported()) {
            serializer.writeUTF8StringBinary(this.name);
            serializer.writeUTF8StringBinary(this.type.name());
        }
        this.flushOffsets(serializer);
        for (IColumn data : this.columnDataArray) {
            data.flushToSerializer(serializer, true);
        }
        if (now) {
            this.buffer.writeTo(serializer);
        }
    }

    public void flushOffsets(BinarySerializer serializer) throws IOException {
        for (long offsetList : this.offsets) {
            serializer.writeLong(offsetList);
        }
    }

    @Override
    public void setColumnWriterBuffer(ColumnWriterBuffer buffer) {
        super.setColumnWriterBuffer(buffer);
        for (IColumn data : this.columnDataArray) {
            data.setColumnWriterBuffer(new ColumnWriterBuffer());
        }
    }

    @Override
    public void clear() {
        this.offsets.clear();
        for (IColumn data : this.columnDataArray) {
            data.clear();
        }
    }
}

