/*
 * Decompiled with CFR 0.152.
 */
package com.github.housepower.data;

import com.github.housepower.buffer.ByteArrayWriter;
import com.github.housepower.serde.BinarySerializer;
import com.github.housepower.settings.ClickHouseDefines;
import java.io.IOException;
import java.nio.Buffer;
import java.nio.ByteBuffer;

public class ColumnWriterBuffer {
    private final ByteArrayWriter columnWriter = new ByteArrayWriter(ClickHouseDefines.COLUMN_BUFFER_BYTES);
    public BinarySerializer column = new BinarySerializer(this.columnWriter, false);

    public void writeTo(BinarySerializer serializer) throws IOException {
        byte[] writeBuffer = new byte[4096];
        for (ByteBuffer buffer : this.columnWriter.getBufferList()) {
            ((Buffer)buffer).flip();
            while (buffer.hasRemaining()) {
                int remaining = buffer.remaining();
                int thisLength = Math.min(remaining, writeBuffer.length);
                buffer.get(writeBuffer, 0, thisLength);
                serializer.writeBytes(writeBuffer, 0, thisLength);
            }
        }
    }

    public void reset() {
        this.columnWriter.reset();
    }
}

