/*
 * Decompiled with CFR 0.152.
 */
package com.github.housepower.data;

import com.github.housepower.client.NativeContext;
import com.github.housepower.data.IDataType;
import com.github.housepower.data.type.DataTypeDate;
import com.github.housepower.data.type.DataTypeDate32;
import com.github.housepower.data.type.DataTypeFloat32;
import com.github.housepower.data.type.DataTypeFloat64;
import com.github.housepower.data.type.DataTypeIPv4;
import com.github.housepower.data.type.DataTypeInt16;
import com.github.housepower.data.type.DataTypeInt32;
import com.github.housepower.data.type.DataTypeInt64;
import com.github.housepower.data.type.DataTypeInt8;
import com.github.housepower.data.type.DataTypeUInt16;
import com.github.housepower.data.type.DataTypeUInt32;
import com.github.housepower.data.type.DataTypeUInt64;
import com.github.housepower.data.type.DataTypeUInt8;
import com.github.housepower.data.type.DataTypeUUID;
import com.github.housepower.data.type.complex.DataTypeArray;
import com.github.housepower.data.type.complex.DataTypeCreator;
import com.github.housepower.data.type.complex.DataTypeDateTime;
import com.github.housepower.data.type.complex.DataTypeDateTime64;
import com.github.housepower.data.type.complex.DataTypeDecimal;
import com.github.housepower.data.type.complex.DataTypeEnum16;
import com.github.housepower.data.type.complex.DataTypeEnum8;
import com.github.housepower.data.type.complex.DataTypeFixedString;
import com.github.housepower.data.type.complex.DataTypeMap;
import com.github.housepower.data.type.complex.DataTypeNothing;
import com.github.housepower.data.type.complex.DataTypeNullable;
import com.github.housepower.data.type.complex.DataTypeString;
import com.github.housepower.data.type.complex.DataTypeTuple;
import com.github.housepower.misc.LRUCache;
import com.github.housepower.misc.SQLLexer;
import com.github.housepower.misc.Validate;
import com.github.housepower.settings.ClickHouseDefines;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public class DataTypeFactory {
    private static final LRUCache<String, IDataType<?, ?>> DATA_TYPE_CACHE = new LRUCache(ClickHouseDefines.DATA_TYPE_CACHE_SIZE);
    private static final Map<String, IDataType<?, ?>> dataTypes = DataTypeFactory.initialDataTypes();

    public static IDataType<?, ?> get(String type, NativeContext.ServerContext serverContext) throws SQLException {
        IDataType<?, ?> dataType = DATA_TYPE_CACHE.get(type);
        if (dataType != null) {
            DATA_TYPE_CACHE.put(type, dataType);
            return dataType;
        }
        SQLLexer lexer = new SQLLexer(0, type);
        dataType = DataTypeFactory.get(lexer, serverContext);
        Validate.isTrue(lexer.eof());
        DATA_TYPE_CACHE.put(type, dataType);
        return dataType;
    }

    public static IDataType<?, ?> get(SQLLexer lexer, NativeContext.ServerContext serverContext) throws SQLException {
        String dataTypeName = String.valueOf(lexer.bareWord());
        if (dataTypeName.equalsIgnoreCase("Tuple")) {
            return DataTypeTuple.creator.createDataType(lexer, serverContext);
        }
        if (dataTypeName.equalsIgnoreCase("Array")) {
            return DataTypeArray.creator.createDataType(lexer, serverContext);
        }
        if (dataTypeName.equalsIgnoreCase("Enum8")) {
            return DataTypeEnum8.creator.createDataType(lexer, serverContext);
        }
        if (dataTypeName.equalsIgnoreCase("Enum16")) {
            return DataTypeEnum16.creator.createDataType(lexer, serverContext);
        }
        if (dataTypeName.equalsIgnoreCase("DateTime")) {
            return DataTypeDateTime.creator.createDataType(lexer, serverContext);
        }
        if (dataTypeName.equalsIgnoreCase("DateTime64")) {
            return DataTypeDateTime64.creator.createDataType(lexer, serverContext);
        }
        if (dataTypeName.equalsIgnoreCase("Nullable")) {
            return DataTypeNullable.creator.createDataType(lexer, serverContext);
        }
        if (dataTypeName.equalsIgnoreCase("FixedString") || dataTypeName.equals("Binary")) {
            return DataTypeFixedString.creator.createDataType(lexer, serverContext);
        }
        if (dataTypeName.equalsIgnoreCase("Decimal")) {
            return DataTypeDecimal.creator.createDataType(lexer, serverContext);
        }
        if (dataTypeName.equalsIgnoreCase("String")) {
            return DataTypeString.CREATOR.createDataType(lexer, serverContext);
        }
        if (dataTypeName.equalsIgnoreCase("Nothing")) {
            return DataTypeNothing.CREATOR.createDataType(lexer, serverContext);
        }
        if (dataTypeName.equalsIgnoreCase("Map")) {
            return DataTypeMap.creator.createDataType(lexer, serverContext);
        }
        IDataType<?, ?> dataType = dataTypes.get(dataTypeName.toLowerCase(Locale.ROOT));
        Validate.isTrue(dataType != null, "Unknown data type: " + dataTypeName);
        return dataType;
    }

    private static Map<String, IDataType<?, ?>> initialDataTypes() {
        HashMap creators = new HashMap();
        DataTypeFactory.registerType(creators, new DataTypeIPv4());
        DataTypeFactory.registerType(creators, new DataTypeUUID());
        DataTypeFactory.registerType(creators, new DataTypeFloat32());
        DataTypeFactory.registerType(creators, new DataTypeFloat64());
        DataTypeFactory.registerType(creators, new DataTypeInt8());
        DataTypeFactory.registerType(creators, new DataTypeInt16());
        DataTypeFactory.registerType(creators, new DataTypeInt32());
        DataTypeFactory.registerType(creators, new DataTypeInt64());
        DataTypeFactory.registerType(creators, new DataTypeUInt8());
        DataTypeFactory.registerType(creators, new DataTypeUInt16());
        DataTypeFactory.registerType(creators, new DataTypeUInt32());
        DataTypeFactory.registerType(creators, new DataTypeUInt64());
        DataTypeFactory.registerType(creators, new DataTypeDate());
        DataTypeFactory.registerType(creators, new DataTypeDate32());
        return creators;
    }

    private static void registerType(Map<String, IDataType<?, ?>> creators, IDataType<?, ?> type) {
        creators.put(type.name().toLowerCase(Locale.ROOT), type);
        for (String typeName : type.getAliases()) {
            creators.put(typeName.toLowerCase(Locale.ROOT), type);
        }
    }

    private static Map<String, DataTypeCreator<?, ?>> initComplexDataTypes() {
        return new HashMap();
    }

    private static void registerComplexType(Map<String, DataTypeCreator<?, ?>> creators, IDataType<?, ?> type, DataTypeCreator<?, ?> creator) {
        creators.put(type.name().toLowerCase(Locale.ROOT), creator);
        for (String typeName : type.getAliases()) {
            creators.put(typeName.toLowerCase(Locale.ROOT), creator);
        }
    }
}

