/*
 * Decompiled with CFR 0.152.
 */
package com.github.housepower.data.type.complex;

import com.github.housepower.data.DataTypeFactory;
import com.github.housepower.data.IDataType;
import com.github.housepower.data.type.DataTypeInt64;
import com.github.housepower.data.type.complex.DataTypeCreator;
import com.github.housepower.jdbc.ClickHouseArray;
import com.github.housepower.misc.SQLLexer;
import com.github.housepower.misc.Validate;
import com.github.housepower.serde.BinaryDeserializer;
import com.github.housepower.serde.BinarySerializer;
import java.io.IOException;
import java.sql.Array;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;

public class DataTypeArray
implements IDataType<ClickHouseArray, Array> {
    public static DataTypeCreator<ClickHouseArray, Array> creator = (lexer, serverContext) -> {
        Validate.isTrue(lexer.character() == '(');
        IDataType<?, ?> arrayNestedType = DataTypeFactory.get(lexer, serverContext);
        Validate.isTrue(lexer.character() == ')');
        return new DataTypeArray("Array(" + arrayNestedType.name() + ")", arrayNestedType, (DataTypeInt64)DataTypeFactory.get("Int64", serverContext));
    };
    private final String name;
    private final ClickHouseArray defaultValue;
    private final IDataType<?, ?> elemDataType;
    private final DataTypeInt64 offsetIDataType;

    public DataTypeArray(String name, IDataType<?, ?> elemDataType, DataTypeInt64 offsetIDataType) throws SQLException {
        this.name = name;
        this.elemDataType = elemDataType;
        this.offsetIDataType = offsetIDataType;
        this.defaultValue = new ClickHouseArray(elemDataType, new Object[]{elemDataType.defaultValue()});
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public int sqlTypeId() {
        return 2003;
    }

    @Override
    public ClickHouseArray defaultValue() {
        return this.defaultValue;
    }

    @Override
    public Class<ClickHouseArray> javaType() {
        return ClickHouseArray.class;
    }

    @Override
    public Class<Array> jdbcJavaType() {
        return Array.class;
    }

    @Override
    public int getPrecision() {
        return 0;
    }

    @Override
    public int getScale() {
        return 0;
    }

    @Override
    public ClickHouseArray deserializeText(SQLLexer lexer) throws SQLException {
        Validate.isTrue(lexer.character() == '[');
        ArrayList arrayData = new ArrayList();
        while (true) {
            if (lexer.isCharacter(']')) break;
            if (lexer.isCharacter(',')) {
                lexer.character();
            }
            arrayData.add(this.elemDataType.deserializeText(lexer));
        }
        lexer.character();
        return new ClickHouseArray(this.elemDataType, arrayData.toArray());
    }

    @Override
    public void serializeBinary(ClickHouseArray data, BinarySerializer serializer) throws SQLException, IOException {
        for (Object f : data.getArray()) {
            this.getElemDataType().serializeBinary(f, serializer);
        }
    }

    public void serializeBinaryBulk(ClickHouseArray[] data, BinarySerializer serializer) throws SQLException, IOException {
        this.offsetIDataType.serializeBinary(Long.valueOf(data.length), serializer);
        this.getElemDataType().serializeBinaryBulk(data, serializer);
    }

    @Override
    public ClickHouseArray deserializeBinary(BinaryDeserializer deserializer) throws SQLException, IOException {
        Long offset = this.offsetIDataType.deserializeBinary(deserializer);
        Object[] data = this.getElemDataType().deserializeBinaryBulk(offset.intValue(), deserializer);
        return new ClickHouseArray(this.elemDataType, data);
    }

    public ClickHouseArray[] deserializeBinaryBulk(int rows, BinaryDeserializer deserializer) throws IOException, SQLException {
        ClickHouseArray[] arrays = new ClickHouseArray[rows];
        if (rows == 0) {
            return arrays;
        }
        int[] offsets = Arrays.stream(this.offsetIDataType.deserializeBinaryBulk(rows, deserializer)).mapToInt(value -> ((Long)value).intValue()).toArray();
        ClickHouseArray res = new ClickHouseArray(this.elemDataType, this.elemDataType.deserializeBinaryBulk(offsets[rows - 1], deserializer));
        int lastOffset = 0;
        for (int row = 0; row < rows; ++row) {
            int offset = offsets[row];
            arrays[row] = res.slice(lastOffset, offset - lastOffset);
            lastOffset = offset;
        }
        return arrays;
    }

    public IDataType getElemDataType() {
        return this.elemDataType;
    }
}

