/*
 * Decompiled with CFR 0.152.
 */
package com.github.housepower.repackaged.io.airlift.compress.lz4;

import com.github.housepower.repackaged.io.airlift.compress.lz4.HadoopLz4InputStream;
import com.github.housepower.repackaged.io.airlift.compress.lz4.HadoopLz4OutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.CompressionInputStream;
import org.apache.hadoop.io.compress.CompressionOutputStream;
import org.apache.hadoop.io.compress.Compressor;
import org.apache.hadoop.io.compress.Decompressor;
import org.apache.hadoop.io.compress.DoNotPool;

public class Lz4Codec
implements Configurable,
CompressionCodec {
    private Configuration conf;

    public Configuration getConf() {
        return this.conf;
    }

    public void setConf(Configuration conf) {
        this.conf = conf;
    }

    public CompressionOutputStream createOutputStream(OutputStream out) throws IOException {
        return new HadoopLz4OutputStream(out, this.getBufferSize());
    }

    public CompressionOutputStream createOutputStream(OutputStream out, Compressor compressor) throws IOException {
        if (!(compressor instanceof HadoopLz4Compressor)) {
            throw new IllegalArgumentException("Compressor is not the LZ4 compressor");
        }
        return new HadoopLz4OutputStream(out, this.getBufferSize());
    }

    public Class<? extends Compressor> getCompressorType() {
        return HadoopLz4Compressor.class;
    }

    public Compressor createCompressor() {
        return new HadoopLz4Compressor();
    }

    public CompressionInputStream createInputStream(InputStream in) throws IOException {
        return new HadoopLz4InputStream(in, this.getBufferSize());
    }

    public CompressionInputStream createInputStream(InputStream in, Decompressor decompressor) throws IOException {
        if (!(decompressor instanceof HadoopLz4Decompressor)) {
            throw new IllegalArgumentException("Decompressor is not the LZ4 decompressor");
        }
        return new HadoopLz4InputStream(in, this.getBufferSize());
    }

    public Class<? extends Decompressor> getDecompressorType() {
        return HadoopLz4Decompressor.class;
    }

    public Decompressor createDecompressor() {
        return new HadoopLz4Decompressor();
    }

    public String getDefaultExtension() {
        return ".lz4";
    }

    private int getBufferSize() {
        int maxUncompressedLength = this.conf != null ? this.conf.getInt("io.compression.codec.lz4.buffersize", 262144) : 262144;
        return maxUncompressedLength;
    }

    @DoNotPool
    private static class HadoopLz4Decompressor
    implements Decompressor {
        private HadoopLz4Decompressor() {
        }

        public void setInput(byte[] b, int off, int len) {
            throw new UnsupportedOperationException("LZ4 block decompressor is not supported");
        }

        public boolean needsInput() {
            throw new UnsupportedOperationException("LZ4 block decompressor is not supported");
        }

        public void setDictionary(byte[] b, int off, int len) {
            throw new UnsupportedOperationException("LZ4 block decompressor is not supported");
        }

        public boolean needsDictionary() {
            throw new UnsupportedOperationException("LZ4 block decompressor is not supported");
        }

        public boolean finished() {
            throw new UnsupportedOperationException("LZ4 block decompressor is not supported");
        }

        public int decompress(byte[] b, int off, int len) throws IOException {
            throw new UnsupportedOperationException("LZ4 block decompressor is not supported");
        }

        public int getRemaining() {
            throw new UnsupportedOperationException("LZ4 block decompressor is not supported");
        }

        public void reset() {
        }

        public void end() {
        }
    }

    @DoNotPool
    private static class HadoopLz4Compressor
    implements Compressor {
        private HadoopLz4Compressor() {
        }

        public void setInput(byte[] b, int off, int len) {
            throw new UnsupportedOperationException("LZ4 block compressor is not supported");
        }

        public boolean needsInput() {
            throw new UnsupportedOperationException("LZ4 block compressor is not supported");
        }

        public void setDictionary(byte[] b, int off, int len) {
            throw new UnsupportedOperationException("LZ4 block compressor is not supported");
        }

        public long getBytesRead() {
            throw new UnsupportedOperationException("LZ4 block compressor is not supported");
        }

        public long getBytesWritten() {
            throw new UnsupportedOperationException("LZ4 block compressor is not supported");
        }

        public void finish() {
            throw new UnsupportedOperationException("LZ4 block compressor is not supported");
        }

        public boolean finished() {
            throw new UnsupportedOperationException("LZ4 block compressor is not supported");
        }

        public int compress(byte[] b, int off, int len) throws IOException {
            throw new UnsupportedOperationException("LZ4 block compressor is not supported");
        }

        public void reset() {
        }

        public void end() {
        }

        public void reinit(Configuration conf) {
        }
    }
}

