/*
 * Decompiled with CFR 0.152.
 */
package com.github.housepower.repackaged.io.airlift.compress.lzo;

import com.github.housepower.repackaged.io.airlift.compress.IncompatibleJvmException;
import java.lang.reflect.Field;
import java.nio.Buffer;
import java.nio.ByteOrder;
import sun.misc.Unsafe;

final class UnsafeUtil {
    public static final Unsafe UNSAFE;
    private static final long ADDRESS_OFFSET;

    private UnsafeUtil() {
    }

    public static long getAddress(Buffer buffer) {
        if (!buffer.isDirect()) {
            throw new IllegalArgumentException("buffer is not direct");
        }
        return UNSAFE.getLong(buffer, ADDRESS_OFFSET);
    }

    static {
        ByteOrder order = ByteOrder.nativeOrder();
        if (!order.equals(ByteOrder.LITTLE_ENDIAN)) {
            throw new IncompatibleJvmException(String.format("LZO requires a little endian platform (found %s)", order));
        }
        try {
            Field theUnsafe = Unsafe.class.getDeclaredField("theUnsafe");
            theUnsafe.setAccessible(true);
            UNSAFE = (Unsafe)theUnsafe.get(null);
        }
        catch (Exception e) {
            throw new IncompatibleJvmException("LZO requires access to sun.misc.Unsafe");
        }
        try {
            ADDRESS_OFFSET = UNSAFE.objectFieldOffset(Buffer.class.getDeclaredField("address"));
        }
        catch (NoSuchFieldException e) {
            throw new IncompatibleJvmException("LZO requires access to java.nio.Buffer raw address field");
        }
    }
}

