/*
 * Decompiled with CFR 0.152.
 */
package com.github.housepower.repackaged.io.airlift.compress.zstd;

import com.github.housepower.repackaged.io.airlift.compress.zstd.BlockCompressionState;
import com.github.housepower.repackaged.io.airlift.compress.zstd.CompressionParameters;
import com.github.housepower.repackaged.io.airlift.compress.zstd.HuffmanCompressionContext;
import com.github.housepower.repackaged.io.airlift.compress.zstd.RepeatedOffsets;
import com.github.housepower.repackaged.io.airlift.compress.zstd.SequenceEncodingContext;
import com.github.housepower.repackaged.io.airlift.compress.zstd.SequenceStore;

class CompressionContext {
    public final RepeatedOffsets offsets = new RepeatedOffsets();
    public final BlockCompressionState blockCompressionState;
    public final SequenceStore sequenceStore;
    public final SequenceEncodingContext sequenceEncodingContext = new SequenceEncodingContext();
    public final HuffmanCompressionContext huffmanContext = new HuffmanCompressionContext();

    public CompressionContext(CompressionParameters parameters, long baseAddress, int inputSize) {
        int windowSize = Math.max(1, Math.min(1 << parameters.getWindowLog(), inputSize));
        int blockSize = Math.min(131072, windowSize);
        int divider = parameters.getSearchLength() == 3 ? 3 : 4;
        int maxSequences = blockSize / divider;
        this.sequenceStore = new SequenceStore(blockSize, maxSequences);
        this.blockCompressionState = new BlockCompressionState(parameters, baseAddress);
    }

    public void commit() {
        this.offsets.commit();
        this.huffmanContext.saveChanges();
    }
}

