/*
 * Decompiled with CFR 0.152.
 */
package com.github.jsonzou.jmockdata.util;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.regex.Pattern;

public class DateTool {
    public static Date getString2Date(String dateStr, String format) throws ParseException {
        return new SimpleDateFormat(format).parse(dateStr);
    }

    public static Date getString2DateAuto(String dateStr) throws ParseException {
        String dateFormat = DateTool.getDateFormat(dateStr);
        return DateTool.getString2Date(dateStr, dateFormat);
    }

    public static String getDateFormat(String dateStr) {
        for (DatePattern dt : DatePattern.values()) {
            if (!dt.getRegx().matcher(dateStr).matches()) continue;
            return dt.getFormat();
        }
        return null;
    }

    public static enum DatePattern {
        yyyy_MM_dd(Pattern.compile("\\d{4}-\\d{2}-\\d{2}"), "yyyy-MM-dd"),
        yyyy_MM_dd__HH$mm$ss(Pattern.compile("\\d{4}-\\d{2}-\\d{2} \\d{2}:\\d{2}:\\d{2}"), "yyyy-MM-dd HH:mm:ss"),
        yyyylMMldd(Pattern.compile("\\d{4}/\\d{2}/\\d{2}"), "yyyy/MM/dd"),
        yyyylMMlddHH__$mm$ss(Pattern.compile("\\d{4}/\\d{2}/\\d{2} \\d{2}:\\d{2}:\\d{2}"), "yyyy/MM/dd HH:mm:ss"),
        yyyyMMdd(Pattern.compile("\\d{8}"), "yyyyMMdd"),
        yyyyMMddHHmmss(Pattern.compile("\\d{14}"), "yyyyMMddHHmmss");

        private Pattern regx;
        private String format;

        private DatePattern(Pattern regx, String format) {
            this.regx = regx;
            this.format = format;
        }

        public Pattern getRegx() {
            return this.regx;
        }

        public void setRegx(Pattern regx) {
            this.regx = regx;
        }

        public String getFormat() {
            return this.format;
        }

        public void setFormat(String format) {
            this.format = format;
        }
    }
}

