/*
 * Decompiled with CFR 0.152.
 */
package com.github.mthizo247.cloud.netflix.zuul.web.authentication;

import com.github.mthizo247.cloud.netflix.zuul.web.authentication.AbstractHeadersCallback;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.web.socket.WebSocketHttpHeaders;
import org.springframework.web.socket.WebSocketSession;

public class LoginCookieHeadersCallback
extends AbstractHeadersCallback {
    protected final Log logger = LogFactory.getLog(this.getClass());

    @Override
    protected void applyHeadersInternal(WebSocketSession userAgentSession, WebSocketHttpHeaders headers) {
        List sessionCookies = userAgentSession.getHandshakeHeaders().get((Object)"Cookie");
        headers.put("Cookie", sessionCookies);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)"Added cookie authentication header to web sockets http headers");
        }
    }

    @Override
    protected boolean shouldApplyHeaders(WebSocketSession userAgentSession, WebSocketHttpHeaders headers) {
        return !headers.containsKey((Object)"Cookie") && userAgentSession.getHandshakeHeaders().containsKey((Object)"Cookie");
    }
}

