/*
 * Decompiled with CFR 0.152.
 */
package com.github.mthizo247.cloud.netflix.zuul.web.authentication;

import com.github.mthizo247.cloud.netflix.zuul.web.authentication.AbstractHeadersCallback;
import java.util.Collections;
import org.springframework.security.oauth2.provider.OAuth2Authentication;
import org.springframework.security.oauth2.provider.authentication.OAuth2AuthenticationDetails;
import org.springframework.web.socket.WebSocketHttpHeaders;
import org.springframework.web.socket.WebSocketSession;

public class OAuth2BearerPrincipalHeadersCallback
extends AbstractHeadersCallback {
    @Override
    protected void applyHeadersInternal(WebSocketSession userAgentSession, WebSocketHttpHeaders headers) {
        OAuth2Authentication oAuth2Authentication = (OAuth2Authentication)userAgentSession.getPrincipal();
        OAuth2AuthenticationDetails details = (OAuth2AuthenticationDetails)oAuth2Authentication.getDetails();
        String accessToken = details.getTokenValue();
        headers.put("Authorization", Collections.singletonList("Bearer " + accessToken));
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Added Oauth2 bearer token authentication header for user " + oAuth2Authentication.getName() + " to web sockets http headers"));
        }
    }

    @Override
    protected boolean shouldApplyHeaders(WebSocketSession userAgentSession, WebSocketHttpHeaders headers) {
        return !headers.containsKey((Object)"Authorization") && userAgentSession.getPrincipal() instanceof OAuth2Authentication;
    }
}

