/*
 * Decompiled with CFR 0.152.
 */
package com.github.mthizo247.cloud.netflix.zuul.web.filter;

import com.netflix.util.Pair;
import com.netflix.zuul.ZuulFilter;
import com.netflix.zuul.context.RequestContext;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.springframework.cloud.netflix.zuul.filters.Route;
import org.springframework.cloud.netflix.zuul.filters.RouteLocator;
import org.springframework.web.servlet.support.ServletUriComponentsBuilder;
import org.springframework.web.util.UriComponents;
import org.springframework.web.util.UrlPathHelper;

public class ProxyRedirectFilter
extends ZuulFilter {
    private static String REDIRECT_TO_URL = "REDIRECT_TO_URL_" + ProxyRedirectFilter.class.getName();
    RouteLocator routeLocator;
    UrlPathHelper urlPathHelper;

    public ProxyRedirectFilter(RouteLocator routeLocator) {
        this(routeLocator, new UrlPathHelper());
    }

    public ProxyRedirectFilter(RouteLocator routeLocator, UrlPathHelper urlPathHelper) {
        this.routeLocator = routeLocator;
        this.urlPathHelper = urlPathHelper;
    }

    public String filterType() {
        return "post";
    }

    public int filterOrder() {
        return 1;
    }

    public boolean shouldFilter() {
        boolean isRedirect;
        RequestContext ctx = RequestContext.getCurrentContext();
        boolean bl = isRedirect = ctx.getResponseStatusCode() == 302;
        if (!isRedirect) {
            return false;
        }
        boolean hasCorrectLocation = false;
        List zuulResponseHeaders = ctx.getZuulResponseHeaders();
        for (Pair zuulResponseHeader : zuulResponseHeaders) {
            if (!"Location".equalsIgnoreCase((String)zuulResponseHeader.first())) continue;
            HttpServletRequest request = ctx.getRequest();
            String path = this.urlPathHelper.getPathWithinApplication(request);
            Route route = this.routeLocator.getMatchingRoute(path);
            UriComponents redirectTo = ServletUriComponentsBuilder.fromHttpUrl((String)((String)zuulResponseHeader.second())).build();
            UriComponents routeLocation = ServletUriComponentsBuilder.fromHttpUrl((String)route.getLocation()).build();
            if (!redirectTo.getHost().equalsIgnoreCase(routeLocation.getHost()) || redirectTo.getPort() != routeLocation.getPort()) continue;
            String toLocation = ServletUriComponentsBuilder.fromHttpUrl((String)((String)zuulResponseHeader.second())).host(request.getServerName()).port(request.getServerPort()).replacePath(this.buildRoutePath(route, (String)zuulResponseHeader.second())).build().toUriString();
            ctx.put((Object)REDIRECT_TO_URL, (Object)toLocation);
            hasCorrectLocation = true;
            break;
        }
        return hasCorrectLocation;
    }

    public Object run() {
        RequestContext ctx = RequestContext.getCurrentContext();
        List zuulResponseHeaders = ctx.getZuulResponseHeaders();
        for (Pair zuulResponseHeader : zuulResponseHeaders) {
            if (!"Location".equalsIgnoreCase((String)zuulResponseHeader.first())) continue;
            zuulResponseHeader.setSecond((Object)ctx.get((Object)REDIRECT_TO_URL).toString());
            break;
        }
        return null;
    }

    private String buildRoutePath(Route route, String httpUrl) {
        String path = ServletUriComponentsBuilder.fromHttpUrl((String)httpUrl).build().getPath();
        return route.getPrefix() == null ? path : route.getPrefix() + path;
    }
}

