/*
 * Decompiled with CFR 0.152.
 */
package com.github.mthizo247.cloud.netflix.zuul.web.socket;

import com.github.mthizo247.cloud.netflix.zuul.web.socket.ProxySessionException;
import com.github.mthizo247.cloud.netflix.zuul.web.socket.WebSocketHttpHeadersCallback;
import java.lang.reflect.Type;
import java.security.Principal;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.messaging.simp.SimpMessagingTemplate;
import org.springframework.messaging.simp.stomp.StompCommand;
import org.springframework.messaging.simp.stomp.StompFrameHandler;
import org.springframework.messaging.simp.stomp.StompHeaders;
import org.springframework.messaging.simp.stomp.StompSession;
import org.springframework.messaging.simp.stomp.StompSessionHandler;
import org.springframework.util.ErrorHandler;
import org.springframework.web.socket.WebSocketHttpHeaders;
import org.springframework.web.socket.WebSocketSession;
import org.springframework.web.socket.client.ConnectionManagerSupport;
import org.springframework.web.socket.messaging.WebSocketStompClient;

public class ProxyWebSocketConnectionManager
extends ConnectionManagerSupport
implements StompSessionHandler {
    private final WebSocketStompClient stompClient;
    private final WebSocketSession userAgentSession;
    private final WebSocketHttpHeadersCallback httpHeadersCallback;
    private StompSession serverSession;
    private Map<String, StompSession.Subscription> subscriptions = new ConcurrentHashMap<String, StompSession.Subscription>();
    private ErrorHandler errorHandler;
    private SimpMessagingTemplate messagingTemplate;

    public ProxyWebSocketConnectionManager(SimpMessagingTemplate messagingTemplate, WebSocketStompClient stompClient, WebSocketSession userAgentSession, WebSocketHttpHeadersCallback httpHeadersCallback, String uri) {
        super(uri, new Object[0]);
        this.messagingTemplate = messagingTemplate;
        this.stompClient = stompClient;
        this.userAgentSession = userAgentSession;
        this.httpHeadersCallback = httpHeadersCallback;
    }

    public void errorHandler(ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    private WebSocketHttpHeaders buildWebSocketHttpHeaders() {
        WebSocketHttpHeaders wsHeaders = new WebSocketHttpHeaders();
        if (this.httpHeadersCallback != null) {
            this.httpHeadersCallback.applyHeaders(this.userAgentSession, wsHeaders);
        }
        return wsHeaders;
    }

    protected void openConnection() {
        this.connect();
    }

    public void connect() {
        try {
            this.serverSession = (StompSession)this.stompClient.connect(this.getUri().toString(), this.buildWebSocketHttpHeaders(), (StompSessionHandler)this, new Object[0]).get();
        }
        catch (Exception e) {
            this.logger.error((Object)("Error connecting to web socket uri " + this.getUri()), (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public void reconnect(long delay) {
        if (delay > 0L) {
            this.logger.warn((Object)("Connection lost or refused, will attempt to reconnect after " + delay + " millis"));
            try {
                Thread.sleep(delay);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        HashSet<String> destinations = new HashSet<String>(this.subscriptions.keySet());
        this.connect();
        for (String destination : destinations) {
            try {
                this.subscribe(destination);
            }
            catch (Exception exception) {}
        }
    }

    protected void closeConnection() throws Exception {
        if (this.isConnected()) {
            this.serverSession.disconnect();
        }
    }

    protected boolean isConnected() {
        return this.serverSession != null && this.serverSession.isConnected();
    }

    public void afterConnected(StompSession session, StompHeaders connectedHeaders) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Proxied target now connected " + session));
        }
    }

    public void handleException(StompSession session, StompCommand command, StompHeaders headers, byte[] payload, Throwable ex) {
        if (this.errorHandler != null) {
            this.errorHandler.handleError((Throwable)new ProxySessionException(this, session, ex));
        }
    }

    public void handleTransportError(StompSession session, Throwable ex) {
        if (this.errorHandler != null) {
            this.errorHandler.handleError((Throwable)new ProxySessionException(this, session, ex));
        }
    }

    public Type getPayloadType(StompHeaders headers) {
        return Object.class;
    }

    public void sendMessage(String destination, Object msg) {
        if (msg instanceof String) {
            this.serverSession.send(destination, (Object)((String)msg).getBytes());
            return;
        }
        this.serverSession.send(destination, msg);
    }

    public void handleFrame(StompHeaders headers, Object payload) {
        if (headers.getDestination() != null) {
            String destination = headers.getDestination();
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Received " + payload + ", To " + headers.getDestination()));
            }
            Principal principal = this.userAgentSession.getPrincipal();
            String userDestinationPrefix = this.messagingTemplate.getUserDestinationPrefix();
            if (principal != null && destination.startsWith(userDestinationPrefix)) {
                destination = (destination = destination.substring(userDestinationPrefix.length())).startsWith("/") ? destination : "/" + destination;
                this.messagingTemplate.convertAndSendToUser(principal.getName(), destination, payload, this.copyHeaders(headers.toSingleValueMap()));
            } else {
                this.messagingTemplate.convertAndSend((Object)destination, payload, this.copyHeaders(headers.toSingleValueMap()));
            }
        }
    }

    private Map<String, Object> copyHeaders(Map<String, String> original) {
        HashMap<String, Object> copy = new HashMap<String, Object>();
        for (String key : original.keySet()) {
            copy.put(key, original.get(key));
        }
        return copy;
    }

    private void connectIfNecessary() {
        if (!this.isConnected()) {
            this.connect();
        }
    }

    public void subscribe(String destination) throws Exception {
        this.connectIfNecessary();
        StompSession.Subscription subscription = this.serverSession.subscribe(destination, (StompFrameHandler)this);
        this.subscriptions.put(destination, subscription);
    }

    public void unsubscribe(String destination) {
        StompSession.Subscription subscription = this.subscriptions.remove(destination);
        if (subscription != null) {
            this.connectIfNecessary();
            subscription.unsubscribe();
        }
    }

    public boolean isConnectedToUserAgent() {
        return this.userAgentSession != null && this.userAgentSession.isOpen();
    }

    public void disconnect() {
        try {
            this.closeConnection();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

