/*
 * Decompiled with CFR 0.152.
 */
package com.github.mthizo247.cloud.netflix.zuul.web.socket;

import com.github.mthizo247.cloud.netflix.zuul.web.socket.ProxyWebSocketConnectionManager;
import com.github.mthizo247.cloud.netflix.zuul.web.socket.WebSocketHttpHeadersCallback;
import com.github.mthizo247.cloud.netflix.zuul.web.socket.WebSocketMessageAccessor;
import com.github.mthizo247.cloud.netflix.zuul.web.socket.ZuulWebSocketProperties;
import com.github.mthizo247.cloud.netflix.zuul.web.target.ProxyTargetResolver;
import java.net.URI;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.messaging.simp.SimpMessagingTemplate;
import org.springframework.messaging.simp.stomp.StompCommand;
import org.springframework.util.Assert;
import org.springframework.util.ErrorHandler;
import org.springframework.util.PatternMatchUtils;
import org.springframework.web.servlet.support.ServletUriComponentsBuilder;
import org.springframework.web.socket.CloseStatus;
import org.springframework.web.socket.WebSocketHandler;
import org.springframework.web.socket.WebSocketMessage;
import org.springframework.web.socket.WebSocketSession;
import org.springframework.web.socket.handler.WebSocketHandlerDecorator;
import org.springframework.web.socket.messaging.WebSocketStompClient;
import org.springframework.web.util.UriComponentsBuilder;

public class ProxyWebSocketHandler
extends WebSocketHandlerDecorator {
    private final Logger logger = LoggerFactory.getLogger(ProxyWebSocketHandler.class);
    private final WebSocketHttpHeadersCallback headersCallback;
    private final SimpMessagingTemplate messagingTemplate;
    private final ProxyTargetResolver proxyTargetResolver;
    private final ZuulWebSocketProperties zuulWebSocketProperties;
    private final WebSocketStompClient stompClient;
    private final Map<WebSocketSession, ProxyWebSocketConnectionManager> managers = new ConcurrentHashMap<WebSocketSession, ProxyWebSocketConnectionManager>();
    private ErrorHandler errorHandler;

    public ProxyWebSocketHandler(WebSocketHandler delegate, WebSocketStompClient stompClient, WebSocketHttpHeadersCallback headersCallback, SimpMessagingTemplate messagingTemplate, ProxyTargetResolver proxyTargetResolver, ZuulWebSocketProperties zuulWebSocketProperties) {
        super(delegate);
        this.stompClient = stompClient;
        this.headersCallback = headersCallback;
        this.messagingTemplate = messagingTemplate;
        this.proxyTargetResolver = proxyTargetResolver;
        this.zuulWebSocketProperties = zuulWebSocketProperties;
    }

    public void errorHandler(ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    private String getWebSocketServerPath(ZuulWebSocketProperties.WsBrokerage wsBrokerage, URI uri) {
        String path = uri.toString();
        if (path.contains(":")) {
            path = UriComponentsBuilder.fromUriString((String)path).build().getPath();
        }
        for (String endPoint : wsBrokerage.getEndPoints()) {
            if (!PatternMatchUtils.simpleMatch((String)this.toPattern(endPoint), (String)(path + "/"))) continue;
            return endPoint;
        }
        return null;
    }

    private ZuulWebSocketProperties.WsBrokerage getWebSocketBrokarage(URI uri) {
        String path = uri.toString();
        if (path.contains(":")) {
            path = UriComponentsBuilder.fromUriString((String)path).build().getPath();
        }
        for (Map.Entry<String, ZuulWebSocketProperties.WsBrokerage> entry : this.zuulWebSocketProperties.getBrokerages().entrySet()) {
            ZuulWebSocketProperties.WsBrokerage wsBrokerage = entry.getValue();
            if (!wsBrokerage.isEnabled()) continue;
            for (String endPoint : wsBrokerage.getEndPoints()) {
                if (!PatternMatchUtils.simpleMatch((String)this.toPattern(endPoint), (String)(path + "/"))) continue;
                return wsBrokerage;
            }
        }
        return null;
    }

    private String toPattern(String path) {
        path = path.startsWith("/") ? "**" + path : "**/" + path;
        return path.endsWith("/") ? path + "**" : path + "/**";
    }

    public void afterConnectionClosed(WebSocketSession session, CloseStatus closeStatus) throws Exception {
        this.disconnectFromProxiedTarget(session);
        super.afterConnectionClosed(session, closeStatus);
    }

    public void handleMessage(WebSocketSession session, WebSocketMessage<?> message) throws Exception {
        super.handleMessage(session, message);
        this.handleMessageFromClient(session, message);
    }

    private void handleMessageFromClient(WebSocketSession session, WebSocketMessage<?> message) throws Exception {
        boolean handled = false;
        WebSocketMessageAccessor accessor = WebSocketMessageAccessor.create(message);
        if (StompCommand.SEND.toString().equalsIgnoreCase(accessor.getCommand())) {
            handled = true;
            this.sendMessageToProxiedTarget(session, accessor);
        }
        if (StompCommand.SUBSCRIBE.toString().equalsIgnoreCase(accessor.getCommand())) {
            handled = true;
            this.subscribeToProxiedTarget(session, accessor);
        }
        if (StompCommand.UNSUBSCRIBE.toString().equalsIgnoreCase(accessor.getCommand())) {
            handled = true;
            this.unsubscribeFromProxiedTarget(session, accessor);
        }
        if (StompCommand.CONNECT.toString().equalsIgnoreCase(accessor.getCommand())) {
            handled = true;
            this.connectToProxiedTarget(session);
        }
        if (!handled && this.logger.isDebugEnabled()) {
            this.logger.debug("STOMP COMMAND " + accessor.getCommand() + " was not explicitly handled");
        }
    }

    private void connectToProxiedTarget(WebSocketSession session) {
        URI sessionUri = session.getUri();
        ZuulWebSocketProperties.WsBrokerage wsBrokerage = this.getWebSocketBrokarage(sessionUri);
        Assert.notNull((Object)wsBrokerage, (String)"wsBrokerage must not be null");
        String path = this.getWebSocketServerPath(wsBrokerage, sessionUri);
        Assert.notNull((Object)path, (String)"Web socket uri path must be null");
        URI routeTarget = this.proxyTargetResolver.resolveTarget(wsBrokerage);
        Assert.notNull((Object)routeTarget, (String)"routeTarget must not be null");
        String uri = ServletUriComponentsBuilder.fromUri((URI)routeTarget).path(path).replaceQuery(sessionUri.getQuery()).toUriString();
        ProxyWebSocketConnectionManager connectionManager = new ProxyWebSocketConnectionManager(this.messagingTemplate, this.stompClient, session, this.headersCallback, uri);
        connectionManager.errorHandler(this.errorHandler);
        this.managers.put(session, connectionManager);
        connectionManager.start();
    }

    private void disconnectFromProxiedTarget(WebSocketSession session) {
        this.disconnectProxyManager(this.managers.remove(session));
    }

    private void disconnectProxyManager(ProxyWebSocketConnectionManager proxyManager) {
        if (proxyManager != null) {
            try {
                proxyManager.disconnect();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    private void unsubscribeFromProxiedTarget(WebSocketSession session, WebSocketMessageAccessor accessor) {
        ProxyWebSocketConnectionManager manager = this.managers.get(session);
        if (manager != null) {
            manager.unsubscribe(accessor.getDestination());
        }
    }

    private void sendMessageToProxiedTarget(WebSocketSession session, WebSocketMessageAccessor accessor) {
        ProxyWebSocketConnectionManager manager = this.managers.get(session);
        manager.sendMessage(accessor.getDestination(), accessor.getPayload());
    }

    private void subscribeToProxiedTarget(WebSocketSession session, WebSocketMessageAccessor accessor) throws Exception {
        ProxyWebSocketConnectionManager manager = this.managers.get(session);
        manager.subscribe(accessor.getDestination());
    }
}

