/*
 * Decompiled with CFR 0.152.
 */
package com.github.mthizo247.cloud.netflix.zuul.web.socket;

import org.springframework.util.StringUtils;
import org.springframework.web.socket.WebSocketMessage;

public final class WebSocketMessageAccessor {
    private String[] messageComponents;

    private WebSocketMessageAccessor() {
    }

    public static WebSocketMessageAccessor create(WebSocketMessage<?> message) {
        String msgPayload = message.getPayload().toString();
        return WebSocketMessageAccessor.create(msgPayload);
    }

    public static WebSocketMessageAccessor create(String message) {
        WebSocketMessageAccessor accessor = new WebSocketMessageAccessor();
        accessor.messageComponents = StringUtils.tokenizeToStringArray((String)message, (String)"\n");
        return accessor;
    }

    public String getCommand() {
        if (this.accessible()) {
            return this.messageComponents[0];
        }
        return null;
    }

    private boolean accessible() {
        return this.messageComponents != null && this.messageComponents.length > 0;
    }

    public String getDestination() {
        return this.getHeader("destination");
    }

    public String getHeader(String header) {
        if (!this.accessible()) {
            return null;
        }
        String string = header = header.endsWith(":") ? header : header + ":";
        if (this.accessible()) {
            for (String messageComponent : this.messageComponents) {
                int indx = messageComponent.indexOf(header);
                if (indx == -1) continue;
                return messageComponent.substring(indx + header.length());
            }
        }
        return null;
    }

    public String getPayload() {
        if (!this.accessible()) {
            return null;
        }
        return this.messageComponents[this.messageComponents.length - 1];
    }
}

