/*
 * Decompiled with CFR 0.152.
 */
package com.github.mthizo247.cloud.netflix.zuul.web.socket;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.PostConstruct;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.util.StringUtils;

@ConfigurationProperties(value="zuul.ws")
public class ZuulWebSocketProperties {
    private boolean enabled = true;
    private Map<String, WsBrokerage> brokerages = new HashMap<String, WsBrokerage>();

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public Map<String, WsBrokerage> getBrokerages() {
        return this.brokerages;
    }

    public void setBrokerages(Map<String, WsBrokerage> brokerages) {
        this.brokerages = brokerages;
    }

    @PostConstruct
    public void init() {
        for (Map.Entry<String, WsBrokerage> entry : this.brokerages.entrySet()) {
            WsBrokerage wsBrokerage = entry.getValue();
            if (StringUtils.hasText((String)wsBrokerage.getId())) continue;
            wsBrokerage.id = entry.getKey();
        }
    }

    public static class WsBrokerage {
        private boolean enabled = true;
        private String id;
        private String routeId;
        private String[] endPoints;
        private String[] brokers;
        private String[] destinationPrefixes;

        public boolean isEnabled() {
            return this.enabled;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public String getRouteId() {
            return this.routeId;
        }

        public void setRouteId(String routeId) {
            this.routeId = routeId;
        }

        public String[] getEndPoints() {
            return this.endPoints;
        }

        public void setEndPoints(String[] endPoints) {
            this.endPoints = endPoints;
        }

        public String[] getBrokers() {
            return this.brokers;
        }

        public void setBrokers(String[] brokers) {
            this.brokers = brokers;
        }

        public String[] getDestinationPrefixes() {
            return this.destinationPrefixes;
        }

        public void setDestinationPrefixes(String[] destinationPrefixes) {
            this.destinationPrefixes = destinationPrefixes;
        }
    }
}

