/*
 * Decompiled with CFR 0.152.
 */
package com.github.mthizo247.cloud.netflix.zuul.web.target;

import com.github.mthizo247.cloud.netflix.zuul.web.socket.ZuulWebSocketProperties;
import com.github.mthizo247.cloud.netflix.zuul.web.target.ProxyTargetResolver;
import com.github.mthizo247.cloud.netflix.zuul.web.util.MapPropertyResolver;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import org.springframework.boot.bind.RelaxedPropertyResolver;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.netflix.zuul.filters.ZuulProperties;
import org.springframework.core.Ordered;
import org.springframework.core.env.PropertyResolver;
import org.springframework.util.Assert;
import org.springframework.web.util.UriComponentsBuilder;

public abstract class AbstractProxyTargetResolver
implements ProxyTargetResolver,
Ordered {
    protected ZuulProperties zuulProperties;
    protected int order = 0;

    public AbstractProxyTargetResolver(ZuulProperties zuulProperties) {
        Assert.notNull((Object)zuulProperties, (String)"zuulProperties must not be null");
        this.zuulProperties = zuulProperties;
    }

    protected ZuulProperties.ZuulRoute resolveRoute(ZuulWebSocketProperties.WsBrokerage wsBrokerage) {
        ZuulProperties.ZuulRoute zuulRoute = (ZuulProperties.ZuulRoute)this.zuulProperties.getRoutes().get(wsBrokerage.getRouteId());
        zuulRoute = zuulRoute == null ? (ZuulProperties.ZuulRoute)this.zuulProperties.getRoutes().get(wsBrokerage.getId()) : zuulRoute;
        return zuulRoute;
    }

    protected URI resolveUri(ServiceInstance serviceInstance) {
        HashMap<String, Object> metadata = new HashMap<String, Object>();
        for (Map.Entry entry : serviceInstance.getMetadata().entrySet()) {
            metadata.put((String)entry.getKey(), entry.getValue());
        }
        UriComponentsBuilder uriBuilder = UriComponentsBuilder.fromUri((URI)serviceInstance.getUri());
        RelaxedPropertyResolver propertyResolver = new RelaxedPropertyResolver((PropertyResolver)new MapPropertyResolver(metadata));
        String configPath = propertyResolver.getProperty("configPath");
        if (configPath != null) {
            uriBuilder.path(configPath);
        }
        return uriBuilder.build().toUri();
    }

    public int getOrder() {
        return this.order;
    }

    public void setOrder(int order) {
        this.order = order;
    }
}

