/*
 * Decompiled with CFR 0.152.
 */
package com.github.mthizo247.cloud.netflix.zuul.web.target;

import com.github.mthizo247.cloud.netflix.zuul.web.socket.ZuulWebSocketProperties;
import com.github.mthizo247.cloud.netflix.zuul.web.target.AbstractProxyTargetResolver;
import java.net.URI;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.loadbalancer.LoadBalancerClient;
import org.springframework.cloud.netflix.zuul.filters.ZuulProperties;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class LoadBalancedProxyTargetResolver
extends AbstractProxyTargetResolver {
    public static final int DEFAULT_ORDER = -2147483638;
    private LoadBalancerClient loadBalancerClient;

    public LoadBalancedProxyTargetResolver(LoadBalancerClient loadBalancerClient, ZuulProperties zuulProperties) {
        super(zuulProperties);
        Assert.notNull((Object)loadBalancerClient, (String)"loadBalancerClient can't be null");
        this.loadBalancerClient = loadBalancerClient;
        this.order = -2147483638;
    }

    @Override
    public URI resolveTarget(ZuulWebSocketProperties.WsBrokerage wsBrokerage) {
        ZuulProperties.ZuulRoute zuulRoute = this.resolveRoute(wsBrokerage);
        if (zuulRoute == null || StringUtils.isEmpty((Object)zuulRoute.getServiceId())) {
            return null;
        }
        ServiceInstance serviceInstance = this.loadBalancerClient.choose(zuulRoute.getServiceId());
        return serviceInstance != null ? this.resolveUri(serviceInstance) : null;
    }
}

