/*
 * Decompiled with CFR 0.152.
 */
package com.github.sd4324530.fastweixin.api;

import com.github.sd4324530.fastweixin.api.BaseAPI;
import com.github.sd4324530.fastweixin.api.config.ApiConfig;
import com.github.sd4324530.fastweixin.api.enums.ResultType;
import com.github.sd4324530.fastweixin.api.response.BaseResponse;
import com.github.sd4324530.fastweixin.api.response.CreateTagResponse;
import com.github.sd4324530.fastweixin.api.response.GetAllTagsResponse;
import com.github.sd4324530.fastweixin.api.response.GetUsersResponse;
import com.github.sd4324530.fastweixin.util.BeanUtil;
import com.github.sd4324530.fastweixin.util.JSONUtil;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TagAPI
extends BaseAPI {
    private static final Logger LOG = LoggerFactory.getLogger(TagAPI.class);

    public TagAPI(ApiConfig config) {
        super(config);
    }

    public CreateTagResponse create(String tagName) {
        BeanUtil.requireNonNull(tagName, "tagName is null");
        LOG.debug("\u521b\u5efa\u6807\u7b7e.....");
        String url = "https://api.weixin.qq.com/cgi-bin/tags/create?access_token=#";
        HashMap<String, Object> param = new HashMap<String, Object>();
        HashMap<String, String> tag = new HashMap<String, String>();
        tag.put("name", tagName);
        param.put("tag", tag);
        BaseResponse r = this.executePost(url, JSONUtil.toJson(param));
        String resultJson = this.isSuccess(r.getErrcode()) ? r.getErrmsg() : r.toJsonString();
        CreateTagResponse response = JSONUtil.toBean(resultJson, CreateTagResponse.class);
        return response;
    }

    public GetAllTagsResponse getAllTags() {
        LOG.debug("\u83b7\u53d6\u5df2\u7ecf\u521b\u5efa\u7684\u6807\u7b7e.....");
        String url = "https://api.weixin.qq.com/cgi-bin/tags/get?access_token=#";
        BaseResponse r = this.executeGet(url);
        String resultJson = this.isSuccess(r.getErrcode()) ? r.getErrmsg() : r.toJsonString();
        GetAllTagsResponse response = JSONUtil.toBean(resultJson, GetAllTagsResponse.class);
        return response;
    }

    public ResultType updateTag(Integer tagId, String newTagName) {
        BeanUtil.requireNonNull(tagId, "tagId is null");
        BeanUtil.requireNonNull(newTagName, "newTagName is null");
        LOG.debug("\u7f16\u8f91\u6807\u7b7e.....");
        String url = "https://api.weixin.qq.com/cgi-bin/tags/update?access_token=#";
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("id", tagId);
        param.put("name", newTagName);
        BaseResponse response = this.executePost(url, JSONUtil.toJson(param));
        return ResultType.get(response.getErrcode());
    }

    public ResultType deleteTag(Integer tagId) {
        BeanUtil.requireNonNull(tagId, "tagId is null");
        LOG.debug("\u5220\u9664\u6807\u7b7e.....");
        String url = "https://api.weixin.qq.com/cgi-bin/tags/delete?access_token=#";
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("id", tagId);
        BaseResponse response = this.executePost(url, JSONUtil.toJson(param));
        return ResultType.get(response.getErrcode());
    }

    public GetUsersResponse getUsersByTagId(Integer tagId, String nextOpenid) {
        BeanUtil.requireNonNull(tagId, "tagId is null");
        LOG.debug("\u5f00\u59cb\u83b7\u53d6\u6807\u7b7e\u4e0b\u7c89\u4e1d.....");
        String url = "https://api.weixin.qq.com/cgi-bin/user/tag/get?access_token=#";
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("tagid", tagId);
        param.put("next_openid", null == nextOpenid ? "" : nextOpenid);
        BaseResponse r = this.executePost(url, JSONUtil.toJson(param));
        String resultJson = this.isSuccess(r.getErrcode()) ? r.getErrmsg() : r.toJsonString();
        GetUsersResponse response = JSONUtil.toBean(resultJson, GetUsersResponse.class);
        return response;
    }
}

