/*
 * Decompiled with CFR 0.152.
 */
package com.power.doc.builder.rpc;

import com.power.common.util.DateTimeUtil;
import com.power.doc.builder.ProjectDocConfigBuilder;
import com.power.doc.builder.rpc.RpcDocBuilderTemplate;
import com.power.doc.model.ApiConfig;
import com.power.doc.model.rpc.RpcApiDoc;
import com.power.doc.template.RpcDocBuildTemplate;
import com.thoughtworks.qdox.JavaProjectBuilder;
import java.util.List;

public class RpcMarkdownBuilder {
    private static final String API_EXTENSION = "Api.md";
    private static final String DATE_FORMAT = "yyyyMMddHHmm";

    public static void buildApiDoc(ApiConfig config) {
        JavaProjectBuilder javaProjectBuilder = new JavaProjectBuilder();
        RpcMarkdownBuilder.buildApiDoc(config, javaProjectBuilder);
    }

    public static void buildApiDoc(ApiConfig config, JavaProjectBuilder javaProjectBuilder) {
        config.setAdoc(false);
        config.setShowJavaType(true);
        RpcDocBuilderTemplate builderTemplate = new RpcDocBuilderTemplate();
        builderTemplate.checkAndInit(config);
        ProjectDocConfigBuilder configBuilder = new ProjectDocConfigBuilder(config, javaProjectBuilder);
        RpcDocBuildTemplate docBuildTemplate = new RpcDocBuildTemplate();
        List<RpcApiDoc> apiDocList = docBuildTemplate.getApiData(configBuilder);
        if (config.isAllInOne()) {
            String version = config.isCoverOld() ? "" : "-V" + DateTimeUtil.long2Str((long)System.currentTimeMillis(), (String)DATE_FORMAT);
            builderTemplate.buildAllInOne(apiDocList, config, javaProjectBuilder, "dubbo/DubboAllInOne.md", "rpc-all" + version + ".md");
        } else {
            builderTemplate.buildApiDoc(apiDocList, config, "dubbo/Dubbo.md", API_EXTENSION);
            builderTemplate.buildErrorCodeDoc(config, "ErrorCodeList.btl", "ErrorCodeList.md");
        }
    }
}

