/*
 * Decompiled with CFR 0.152.
 */
package com.power.doc.helper;

import com.power.common.util.JsonFormatUtil;
import com.power.common.util.StringUtil;
import com.power.doc.builder.ProjectDocConfigBuilder;
import com.power.doc.model.ApiConfig;
import com.power.doc.model.ApiReturn;
import com.power.doc.model.CustomRespField;
import com.power.doc.model.DocJavaField;
import com.power.doc.model.DocJavaMethod;
import com.power.doc.utils.DocClassUtil;
import com.power.doc.utils.DocUtil;
import com.power.doc.utils.JavaClassUtil;
import com.power.doc.utils.JavaClassValidateUtil;
import com.power.doc.utils.JavaFieldUtil;
import com.thoughtworks.qdox.model.JavaAnnotation;
import com.thoughtworks.qdox.model.JavaClass;
import com.thoughtworks.qdox.model.JavaField;
import com.thoughtworks.qdox.model.JavaMethod;
import com.thoughtworks.qdox.model.JavaType;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class JsonBuildHelper {
    public static String buildReturnJson(DocJavaMethod docJavaMethod, ProjectDocConfigBuilder builder) {
        JavaMethod method = docJavaMethod.getJavaMethod();
        if (method.getReturns().isVoid()) {
            return "This api return nothing.";
        }
        String returnTypeGenericCanonicalName = method.getReturnType().getGenericCanonicalName();
        if (Objects.nonNull(builder.getApiConfig().getResponseBodyAdvice()) && Objects.isNull(method.getTagByName("ignoreResponseBodyAdvice"))) {
            String responseBodyAdvice = builder.getApiConfig().getResponseBodyAdvice().getClassName();
            StringBuilder sb = new StringBuilder();
            sb.append(responseBodyAdvice).append("<").append(returnTypeGenericCanonicalName).append(">");
            returnTypeGenericCanonicalName = sb.toString();
        }
        ApiReturn apiReturn = DocClassUtil.processReturnType(returnTypeGenericCanonicalName);
        String typeName = apiReturn.getSimpleName();
        Map<String, JavaType> actualTypesMap = docJavaMethod.getActualTypesMap();
        String returnType = apiReturn.getGenericCanonicalName();
        if (Objects.nonNull(actualTypesMap)) {
            for (Map.Entry<String, JavaType> entry : actualTypesMap.entrySet()) {
                typeName = typeName.replace(entry.getKey(), entry.getValue().getCanonicalName());
                returnType = returnType.replace(entry.getKey(), entry.getValue().getCanonicalName());
            }
        }
        return JsonFormatUtil.formatJson((String)JsonBuildHelper.buildJson(typeName, returnType, Boolean.TRUE, 0, new HashMap<String, String>(), builder));
    }

    public static String buildJson(String typeName, String genericCanonicalName, boolean isResp, int counter, Map<String, String> registryClasses, ProjectDocConfigBuilder builder) {
        HashMap<String, String> genericMap = new HashMap<String, String>(10);
        JavaClass javaClass = builder.getJavaProjectBuilder().getClassByName(typeName);
        ApiConfig apiConfig = builder.getApiConfig();
        if (counter > apiConfig.getRecursionLimit()) {
            return "{\"$ref\":\"...\"}";
        }
        if (registryClasses.containsKey(typeName) && counter > registryClasses.size()) {
            return "{\"$ref\":\"...\"}";
        }
        int nextLevel = counter + 1;
        registryClasses.put(typeName, typeName);
        if (JavaClassValidateUtil.isMvcIgnoreParams(typeName, builder.getApiConfig().getIgnoreRequestParams())) {
            if ("org.springframework.web.servlet.ModelAndView".equals(typeName)) {
                return "Forward or redirect to a page view.";
            }
            return "Error restful return.";
        }
        if (JavaClassValidateUtil.isPrimitive(typeName)) {
            if ("java.lang.String".equals(typeName)) {
                return "string";
            }
            return StringUtil.removeQuotes((String)DocUtil.jsonValueByType(typeName));
        }
        if (javaClass.isEnum()) {
            return String.valueOf(JavaClassUtil.getEnumValue(javaClass, Boolean.FALSE));
        }
        boolean skipTransientField = apiConfig.isSkipTransientField();
        StringBuilder data0 = new StringBuilder();
        JavaClass cls = builder.getClassByName(typeName);
        data0.append("{");
        String[] globGicName = DocClassUtil.getSimpleGicName(genericCanonicalName);
        JavaClassUtil.genericParamMap(genericMap, cls, globGicName);
        StringBuilder data = new StringBuilder();
        if (JavaClassValidateUtil.isCollection(typeName) || JavaClassValidateUtil.isArray(typeName)) {
            String gName;
            data.append("[");
            if (globGicName.length == 0) {
                data.append("{\"object\":\"any object\"}");
                data.append("]");
                return data.toString();
            }
            String gNameTemp = globGicName[0];
            String string = gName = JavaClassValidateUtil.isArray(gNameTemp) ? gNameTemp.substring(0, gNameTemp.indexOf("[")) : globGicName[0];
            if ("java.lang.Object".equals(gName)) {
                data.append("{\"waring\":\"You may use java.util.Object instead of display generics in the List\"}");
            } else if (JavaClassValidateUtil.isPrimitive(gName)) {
                data.append(DocUtil.jsonValueByType(gName)).append(",");
                data.append(DocUtil.jsonValueByType(gName));
            } else if (gName.contains("<")) {
                String simple = DocClassUtil.getSimpleName(gName);
                String json = JsonBuildHelper.buildJson(simple, gName, isResp, nextLevel, registryClasses, builder);
                data.append(json);
            } else if (JavaClassValidateUtil.isCollection(gName)) {
                data.append("\"any object\"");
            } else {
                String json = JsonBuildHelper.buildJson(gName, gName, isResp, nextLevel, registryClasses, builder);
                data.append(json);
            }
            data.append("]");
            return data.toString();
        }
        if (JavaClassValidateUtil.isMap(typeName)) {
            String gNameTemp = genericCanonicalName;
            String[] getKeyValType = DocClassUtil.getMapKeyValueType(gNameTemp);
            if (getKeyValType.length == 0) {
                data.append("{\"mapKey\":{}}");
                return data.toString();
            }
            if (!"java.lang.String".equals(getKeyValType[0])) {
                throw new RuntimeException("Map's key can only use String for json,but you use " + getKeyValType[0]);
            }
            String gicName = gNameTemp.substring(gNameTemp.indexOf(",") + 1, gNameTemp.lastIndexOf(">"));
            if ("java.lang.Object".equals(gicName)) {
                data.append("{").append("\"mapKey\":").append("{\"waring\":\"You may use java.util.Object for Map value; smart-doc can't be handle.\"}").append("}");
            } else if (JavaClassValidateUtil.isPrimitive(gicName)) {
                data.append("{").append("\"mapKey1\":").append(DocUtil.jsonValueByType(gicName)).append(",");
                data.append("\"mapKey2\":").append(DocUtil.jsonValueByType(gicName)).append("}");
            } else if (gicName.contains("<")) {
                String simple = DocClassUtil.getSimpleName(gicName);
                String json = JsonBuildHelper.buildJson(simple, gicName, isResp, nextLevel, registryClasses, builder);
                data.append("{").append("\"mapKey\":").append(json).append("}");
            } else {
                data.append("{").append("\"mapKey\":").append(JsonBuildHelper.buildJson(gicName, gNameTemp, isResp, counter + 1, registryClasses, builder)).append("}");
            }
            return data.toString();
        }
        if ("java.lang.Object".equals(typeName)) {
            data.append("{\"object\":\" any object\"},");
        } else {
            boolean requestFieldToUnderline = builder.getApiConfig().isRequestFieldToUnderline();
            boolean responseFieldToUnderline = builder.getApiConfig().isResponseFieldToUnderline();
            List<DocJavaField> fields = JavaClassUtil.getFields(cls, 0, new HashSet<String>());
            boolean isGenerics = JavaFieldUtil.checkGenerics(fields);
            block0: for (DocJavaField docField : fields) {
                String gicName1;
                String gicName;
                JavaField field = docField.getJavaField();
                String subTypeName = docField.getFullyQualifiedName();
                String fieldName = field.getName();
                if (field.isStatic() || "this$0".equals(fieldName) || JavaClassValidateUtil.isIgnoreFieldTypes(subTypeName) || field.isTransient() && skipTransientField) continue;
                if (responseFieldToUnderline && isResp || requestFieldToUnderline && !isResp) {
                    fieldName = StringUtil.camelToUnderline((String)fieldName);
                }
                Map<String, String> tagsMap = DocUtil.getFieldTagsValue(field, docField);
                if (!isResp && tagsMap.containsKey("ignore")) continue;
                List<JavaAnnotation> annotations = docField.getAnnotations();
                for (JavaAnnotation annotation : annotations) {
                    String annotationName = annotation.getType().getValue();
                    if ("JsonIgnore".equals(annotationName)) continue block0;
                    if ("JSONField".equals(annotationName)) {
                        if (null != annotation.getProperty("serialize")) {
                            if (!Boolean.FALSE.toString().equals(annotation.getProperty("serialize").toString())) continue;
                            continue block0;
                        }
                        if (null == annotation.getProperty("name")) continue;
                        fieldName = StringUtil.removeQuotes((String)annotation.getProperty("name").toString());
                        continue;
                    }
                    if (!"JsonProperty".equals(annotationName) || null == annotation.getProperty("value")) continue;
                    fieldName = StringUtil.removeQuotes((String)annotation.getProperty("value").toString());
                }
                String typeSimpleName = field.getType().getSimpleName();
                String fieldGicName = docField.getGenericCanonicalName();
                data0.append("\"").append(fieldName).append("\":");
                String fieldValue = "";
                if (tagsMap.containsKey("mock") && StringUtil.isNotEmpty((String)tagsMap.get("mock"))) {
                    fieldValue = tagsMap.get("mock");
                    if (!(DocUtil.javaPrimaryType(typeSimpleName) || JavaClassValidateUtil.isCollection(fieldGicName) || JavaClassValidateUtil.isMap(fieldGicName))) {
                        fieldValue = DocUtil.handleJsonStr(fieldValue);
                    }
                }
                if (JavaClassValidateUtil.isPrimitive(subTypeName)) {
                    CustomRespField customResponseField;
                    if (StringUtil.isEmpty((String)fieldValue)) {
                        fieldValue = DocUtil.getValByTypeAndFieldName(typeSimpleName, field.getName());
                    }
                    if (null != (customResponseField = builder.getCustomRespFieldMap().get(fieldName))) {
                        Object val = customResponseField.getValue();
                        if (null != val) {
                            if (DocUtil.javaPrimaryType(typeSimpleName)) {
                                data0.append(val).append(",");
                                continue;
                            }
                            data0.append(DocUtil.handleJsonStr(String.valueOf(val))).append(",");
                            continue;
                        }
                        data0.append(fieldValue).append(",");
                        continue;
                    }
                    data0.append(fieldValue).append(",");
                    continue;
                }
                if (JavaClassValidateUtil.isCollection(subTypeName) || JavaClassValidateUtil.isArray(subTypeName)) {
                    if (StringUtil.isNotEmpty((String)fieldValue)) {
                        data0.append(fieldValue).append(",");
                        continue;
                    }
                    if (globGicName.length > 0 && "java.util.List".equals(fieldGicName)) {
                        fieldGicName = fieldGicName + "<T>";
                    }
                    String string = fieldGicName = JavaClassValidateUtil.isArray(subTypeName) ? fieldGicName.substring(0, fieldGicName.indexOf("[")) : fieldGicName;
                    if (DocClassUtil.getSimpleGicName(fieldGicName).length == 0) {
                        data0.append("[{\"object\":\"any object\"}],");
                        continue;
                    }
                    gicName = DocClassUtil.getSimpleGicName(fieldGicName)[0];
                    if ("java.lang.String".equals(gicName)) {
                        data0.append("[").append("\"").append(JsonBuildHelper.buildJson(gicName, fieldGicName, isResp, nextLevel, registryClasses, builder)).append("\"]").append(",");
                        continue;
                    }
                    if ("java.util.List".equals(gicName)) {
                        data0.append("[{\"object\":\"any object\"}],");
                        continue;
                    }
                    if (gicName.length() == 1) {
                        if (globGicName.length == 0) {
                            data0.append("[{\"object\":\"any object\"}],");
                            continue;
                        }
                        String string2 = gicName1 = genericMap.get(gicName) == null ? globGicName[0] : (String)genericMap.get(gicName);
                        if ("java.lang.String".equals(gicName1)) {
                            data0.append("[").append("\"").append(JsonBuildHelper.buildJson(gicName1, gicName1, isResp, nextLevel, registryClasses, builder)).append("\"]").append(",");
                            continue;
                        }
                        if (!typeName.equals(gicName1)) {
                            data0.append("[").append(JsonBuildHelper.buildJson(DocClassUtil.getSimpleName(gicName1), gicName1, isResp, nextLevel, registryClasses, builder)).append("]").append(",");
                            continue;
                        }
                        data0.append("[{\"$ref\":\"..\"}]").append(",");
                        continue;
                    }
                    if (!typeName.equals(gicName)) {
                        if (JavaClassValidateUtil.isMap(gicName)) {
                            data0.append("[{\"mapKey\":{}}],");
                            continue;
                        }
                        data0.append("[").append(JsonBuildHelper.buildJson(gicName, fieldGicName, isResp, nextLevel, registryClasses, builder)).append("]").append(",");
                        continue;
                    }
                    data0.append("[{\"$ref\":\"..\"}]").append(",");
                    continue;
                }
                if (JavaClassValidateUtil.isMap(subTypeName)) {
                    if (StringUtil.isNotEmpty((String)fieldValue)) {
                        data0.append(fieldValue).append(",");
                        continue;
                    }
                    if (JavaClassValidateUtil.isMap(fieldGicName)) {
                        data0.append("{").append("\"mapKey\":{}},");
                        continue;
                    }
                    gicName = fieldGicName.substring(fieldGicName.indexOf(",") + 1, fieldGicName.indexOf(">"));
                    if (gicName.length() == 1) {
                        String string = gicName1 = genericMap.get(gicName) == null ? globGicName[0] : (String)genericMap.get(gicName);
                        if ("java.lang.String".equals(gicName1)) {
                            data0.append("{").append("\"mapKey\":\"").append(JsonBuildHelper.buildJson(gicName1, gicName1, isResp, nextLevel, registryClasses, builder)).append("\"},");
                            continue;
                        }
                        if (!typeName.equals(gicName1)) {
                            data0.append("{").append("\"mapKey\":").append(JsonBuildHelper.buildJson(DocClassUtil.getSimpleName(gicName1), gicName1, isResp, nextLevel, registryClasses, builder)).append("},");
                            continue;
                        }
                        data0.append("{\"mapKey\":{}},");
                        continue;
                    }
                    data0.append("{").append("\"mapKey\":").append(JsonBuildHelper.buildJson(gicName, fieldGicName, isResp, nextLevel, registryClasses, builder)).append("},");
                    continue;
                }
                if (subTypeName.length() == 1) {
                    if (!typeName.equals(genericCanonicalName)) {
                        String string = gicName = genericMap.get(subTypeName) == null ? globGicName[0] : (String)genericMap.get(subTypeName);
                        if (JavaClassValidateUtil.isPrimitive(gicName)) {
                            data0.append(DocUtil.jsonValueByType(gicName)).append(",");
                            continue;
                        }
                        String simple = DocClassUtil.getSimpleName(gicName);
                        data0.append(JsonBuildHelper.buildJson(simple, gicName, isResp, nextLevel, registryClasses, builder)).append(",");
                        continue;
                    }
                    data0.append("{\"waring\":\"You may have used non-display generics.\"},");
                    continue;
                }
                if ("java.lang.Object".equals(subTypeName)) {
                    if (isGenerics) {
                        data0.append("{\"object\":\"any object\"},");
                        continue;
                    }
                    if (globGicName.length > 0) {
                        String string = gicName = genericMap.get(subTypeName) == null ? globGicName[0] : (String)genericMap.get(subTypeName);
                        if (!typeName.equals(genericCanonicalName)) {
                            if (JavaClassValidateUtil.isPrimitive(gicName)) {
                                data0.append("\"").append(JsonBuildHelper.buildJson(gicName, genericCanonicalName, isResp, nextLevel, registryClasses, builder)).append("\",");
                                continue;
                            }
                            String simpleName = DocClassUtil.getSimpleName(gicName);
                            data0.append(JsonBuildHelper.buildJson(simpleName, gicName, isResp, nextLevel, registryClasses, builder)).append(",");
                            continue;
                        }
                        data0.append("{\"waring\":\"You may have used non-display generics.\"},");
                        continue;
                    }
                    data0.append("{\"waring\":\"You may have used non-display generics.\"},");
                    continue;
                }
                if (typeName.equals(subTypeName)) {
                    data0.append("{\"$ref\":\"...\"}").append(",");
                    continue;
                }
                javaClass = builder.getJavaProjectBuilder().getClassByName(subTypeName);
                if (!isResp && javaClass.isEnum()) {
                    Object value = JavaClassUtil.getEnumValue(javaClass, Boolean.FALSE);
                    data0.append(value).append(",");
                    continue;
                }
                data0.append(JsonBuildHelper.buildJson(subTypeName, fieldGicName, isResp, nextLevel, registryClasses, builder)).append(",");
            }
        }
        if (data0.toString().contains(",")) {
            data0.deleteCharAt(data0.lastIndexOf(","));
        }
        data0.append("}");
        return data0.toString();
    }
}

