/*
 * Decompiled with CFR 0.152.
 */
package com.power.doc.model;

import com.power.common.util.CollectionUtil;
import com.power.doc.constants.DocLanguage;
import com.power.doc.model.ApiConstant;
import com.power.doc.model.ApiDataDictionary;
import com.power.doc.model.ApiErrorCode;
import com.power.doc.model.ApiErrorCodeDictionary;
import com.power.doc.model.ApiObjectReplacement;
import com.power.doc.model.ApiReqHeader;
import com.power.doc.model.CustomRespField;
import com.power.doc.model.ResponseBodyAdvice;
import com.power.doc.model.RevisionLog;
import com.power.doc.model.SourceCodePath;
import com.power.doc.model.rpc.RpcApiDependency;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class ApiConfig {
    private String serverUrl;
    private boolean isStrict;
    private boolean allInOne;
    private String outPath;
    private List<SourceCodePath> sourceCodePaths;
    private List<ApiReqHeader> requestHeaders;
    private boolean coverOld;
    private List<CustomRespField> customResponseFields;
    private List<ApiErrorCode> errorCodes;
    private String packageFilters;
    private List<RevisionLog> revisionLogs;
    private boolean md5EncryptedHtmlName;
    private DocLanguage language;
    private boolean adoc;
    private List<ApiDataDictionary> dataDictionaries;
    private List<ApiErrorCodeDictionary> errorCodeDictionaries;
    private List<ApiObjectReplacement> apiObjectReplacements;
    private List<RpcApiDependency> rpcApiDependencies;
    private List<ApiConstant> apiConstants;
    private String projectName;
    private boolean skipTransientField = true;
    private boolean showAuthor = true;
    private boolean requestFieldToUnderline;
    private boolean responseFieldToUnderline;
    private boolean sortByTitle;
    private Boolean showJavaType = Boolean.FALSE;
    private Boolean inlineEnum = Boolean.FALSE;
    private String rpcConsumerConfig;
    private int recursionLimit = 7;
    private boolean requestExample = Boolean.TRUE;
    private boolean responseExample = Boolean.TRUE;
    private String allInOneDocFileName;
    private boolean paramsDataToTree;
    private List<String> ignoreRequestParams;
    private boolean displayActualType;
    private ResponseBodyAdvice responseBodyAdvice;
    private String style;
    private boolean createDebugPage;

    public String getServerUrl() {
        return this.serverUrl;
    }

    public void setServerUrl(String serverUrl) {
        this.serverUrl = serverUrl;
    }

    public boolean isStrict() {
        return this.isStrict;
    }

    public void setStrict(boolean strict) {
        this.isStrict = strict;
    }

    public String getOutPath() {
        return this.outPath;
    }

    public void setOutPath(String outPath) {
        this.outPath = outPath;
    }

    public List<ApiReqHeader> getRequestHeaders() {
        return this.requestHeaders;
    }

    public void setRequestHeaders(ApiReqHeader ... requestHeaders) {
        this.requestHeaders = CollectionUtil.asList((Object[])requestHeaders);
        this.requestHeaders.stream().map(header -> header.setDesc(header.getDesc() + "(Global)")).collect(Collectors.toList());
    }

    public List<CustomRespField> getCustomResponseFields() {
        return this.customResponseFields;
    }

    public void setCustomResponseFields(CustomRespField ... customResponseFields) {
        this.customResponseFields = CollectionUtil.asList((Object[])customResponseFields);
    }

    public List<ApiErrorCode> getErrorCodes() {
        return this.errorCodes;
    }

    public void setErrorCodes(List<ApiErrorCode> errorCodes) {
        this.errorCodes = errorCodes;
    }

    public List<SourceCodePath> getSourceCodePaths() {
        return this.sourceCodePaths;
    }

    public void setSourceCodePaths(SourceCodePath ... sourcePaths) {
        this.sourceCodePaths = CollectionUtil.asList((Object[])sourcePaths);
    }

    public boolean isAllInOne() {
        return this.allInOne;
    }

    public void setAllInOne(boolean allInOne) {
        this.allInOne = allInOne;
    }

    public String getPackageFilters() {
        return this.packageFilters;
    }

    public void setPackageFilters(String packageFilters) {
        this.packageFilters = packageFilters;
    }

    public List<RevisionLog> getRevisionLogs() {
        return this.revisionLogs;
    }

    public void setRevisionLogs(RevisionLog ... revisionLogs) {
        this.revisionLogs = CollectionUtil.asList((Object[])revisionLogs);
    }

    public boolean isMd5EncryptedHtmlName() {
        return this.md5EncryptedHtmlName;
    }

    public void setMd5EncryptedHtmlName(boolean md5EncryptedHtmlName) {
        this.md5EncryptedHtmlName = md5EncryptedHtmlName;
    }

    public DocLanguage getLanguage() {
        return this.language;
    }

    public void setLanguage(DocLanguage language) {
        this.language = language;
    }

    public boolean isAdoc() {
        return this.adoc;
    }

    public void setAdoc(boolean adoc) {
        this.adoc = adoc;
    }

    public List<ApiDataDictionary> getDataDictionaries() {
        return this.dataDictionaries;
    }

    public void setDataDictionaries(ApiDataDictionary ... dataDictConfigs) {
        this.dataDictionaries = CollectionUtil.asList((Object[])dataDictConfigs);
    }

    public ApiDataDictionary getDataDictionary(String enumClassSimpleName) {
        if (Objects.isNull(this.dataDictionaries)) {
            return null;
        }
        return this.dataDictionaries.stream().filter(apiDataDictionary -> enumClassSimpleName.equalsIgnoreCase(apiDataDictionary.getEnumClassName())).findFirst().orElse(new ApiDataDictionary());
    }

    public List<ApiErrorCodeDictionary> getErrorCodeDictionaries() {
        return this.errorCodeDictionaries;
    }

    public void setErrorCodeDictionaries(ApiErrorCodeDictionary ... errorCodeDictConfigs) {
        this.errorCodeDictionaries = CollectionUtil.asList((Object[])errorCodeDictConfigs);
    }

    public List<ApiObjectReplacement> getApiObjectReplacements() {
        return this.apiObjectReplacements;
    }

    public void setApiObjectReplacements(ApiObjectReplacement ... apiObjectReplaces) {
        this.apiObjectReplacements = CollectionUtil.asList((Object[])apiObjectReplaces);
    }

    public List<RpcApiDependency> getRpcApiDependencies() {
        return this.rpcApiDependencies;
    }

    public void setRpcApiDependencies(RpcApiDependency ... rpcApiDependencies) {
        this.rpcApiDependencies = CollectionUtil.asList((Object[])rpcApiDependencies);
    }

    public List<ApiConstant> getApiConstants() {
        return this.apiConstants;
    }

    public void setApiConstants(ApiConstant ... apiConstants) {
        this.apiConstants = CollectionUtil.asList((Object[])apiConstants);
    }

    public boolean isCoverOld() {
        return this.coverOld;
    }

    public void setCoverOld(boolean coverOld) {
        this.coverOld = coverOld;
    }

    public String getProjectName() {
        return this.projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public boolean isSkipTransientField() {
        return this.skipTransientField;
    }

    public void setSkipTransientField(boolean skipTransientField) {
        this.skipTransientField = skipTransientField;
    }

    public boolean isShowAuthor() {
        return this.showAuthor;
    }

    public void setShowAuthor(boolean showAuthor) {
        this.showAuthor = showAuthor;
    }

    public boolean isRequestFieldToUnderline() {
        return this.requestFieldToUnderline;
    }

    public void setRequestFieldToUnderline(boolean requestFieldToUnderline) {
        this.requestFieldToUnderline = requestFieldToUnderline;
    }

    public boolean isResponseFieldToUnderline() {
        return this.responseFieldToUnderline;
    }

    public void setResponseFieldToUnderline(boolean responseFieldToUnderline) {
        this.responseFieldToUnderline = responseFieldToUnderline;
    }

    public boolean isSortByTitle() {
        return this.sortByTitle;
    }

    public void setSortByTitle(boolean sortByTitle) {
        this.sortByTitle = sortByTitle;
    }

    public Boolean getShowJavaType() {
        return this.showJavaType;
    }

    public void setShowJavaType(Boolean showJavaType) {
        this.showJavaType = showJavaType;
    }

    public String getRpcConsumerConfig() {
        return this.rpcConsumerConfig;
    }

    public void setRpcConsumerConfig(String rpcConsumerConfig) {
        this.rpcConsumerConfig = rpcConsumerConfig;
    }

    public Boolean getInlineEnum() {
        return this.inlineEnum;
    }

    public void setInlineEnum(Boolean inlineEnum) {
        this.inlineEnum = inlineEnum;
    }

    public int getRecursionLimit() {
        return this.recursionLimit;
    }

    public void setRecursionLimit(int recursionLimit) {
        this.recursionLimit = recursionLimit;
    }

    public boolean isRequestExample() {
        return this.requestExample;
    }

    public void setRequestExample(boolean requestExample) {
        this.requestExample = requestExample;
    }

    public boolean isResponseExample() {
        return this.responseExample;
    }

    public void setResponseExample(boolean responseExample) {
        this.responseExample = responseExample;
    }

    public String getAllInOneDocFileName() {
        return this.allInOneDocFileName;
    }

    public void setAllInOneDocFileName(String allInOneDocFileName) {
        this.allInOneDocFileName = allInOneDocFileName;
    }

    public boolean isParamsDataToTree() {
        return this.paramsDataToTree;
    }

    public void setParamsDataToTree(boolean paramsDataToTree) {
        this.paramsDataToTree = paramsDataToTree;
    }

    public List<String> getIgnoreRequestParams() {
        return this.ignoreRequestParams;
    }

    public void setIgnoreRequestParams(List<String> ignoreRequestParams) {
        this.ignoreRequestParams = ignoreRequestParams;
    }

    public boolean isDisplayActualType() {
        return this.displayActualType;
    }

    public void setDisplayActualType(boolean displayActualType) {
        this.displayActualType = displayActualType;
    }

    public ResponseBodyAdvice getResponseBodyAdvice() {
        return this.responseBodyAdvice;
    }

    public void setResponseBodyAdvice(ResponseBodyAdvice responseBodyAdvice) {
        this.responseBodyAdvice = responseBodyAdvice;
    }

    public String getStyle() {
        return this.style;
    }

    public void setStyle(String style) {
        this.style = style;
    }

    public boolean isCreateDebugPage() {
        return this.createDebugPage;
    }

    public void setCreateDebugPage(boolean createDebugPage) {
        this.createDebugPage = createDebugPage;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        sb.append("\"serverUrl\":\"").append(this.serverUrl).append('\"');
        sb.append(",\"isStrict\":").append(this.isStrict);
        sb.append(",\"allInOne\":").append(this.allInOne);
        sb.append(",\"outPath\":\"").append(this.outPath).append('\"');
        sb.append(",\"sourceCodePaths\":").append(this.sourceCodePaths);
        sb.append(",\"requestHeaders\":").append(this.requestHeaders);
        sb.append(",\"coverOld\":").append(this.coverOld);
        sb.append(",\"customResponseFields\":").append(this.customResponseFields);
        sb.append(",\"errorCodes\":").append(this.errorCodes);
        sb.append(",\"packageFilters\":\"").append(this.packageFilters).append('\"');
        sb.append(",\"revisionLogs\":").append(this.revisionLogs);
        sb.append(",\"md5EncryptedHtmlName\":").append(this.md5EncryptedHtmlName);
        sb.append(",\"language\":").append((Object)this.language);
        sb.append(",\"adoc\":").append(this.adoc);
        sb.append(",\"dataDictionaries\":").append(this.dataDictionaries);
        sb.append(",\"errorCodeDictionaries\":").append(this.errorCodeDictionaries);
        sb.append(",\"apiObjectReplacements\":").append(this.apiObjectReplacements);
        sb.append(",\"rpcApiDependencies\":").append(this.rpcApiDependencies);
        sb.append(",\"apiConstants\":").append(this.apiConstants);
        sb.append(",\"projectName\":\"").append(this.projectName).append('\"');
        sb.append(",\"skipTransientField\":").append(this.skipTransientField);
        sb.append(",\"showAuthor\":").append(this.showAuthor);
        sb.append(",\"requestFieldToUnderline\":").append(this.requestFieldToUnderline);
        sb.append(",\"responseFieldToUnderline\":").append(this.responseFieldToUnderline);
        sb.append(",\"sortByTitle\":").append(this.sortByTitle);
        sb.append(",\"showJavaType\":").append(this.showJavaType);
        sb.append(",\"inlineEnum\":").append(this.inlineEnum);
        sb.append(",\"rpcConsumerConfig\":\"").append(this.rpcConsumerConfig).append('\"');
        sb.append(",\"recursionLimit\":").append(this.recursionLimit);
        sb.append(",\"requestExample\":").append(this.requestExample);
        sb.append(",\"responseExample\":").append(this.responseExample);
        sb.append(",\"allInOneDocFileName\":\"").append(this.allInOneDocFileName).append('\"');
        sb.append(",\"paramsDataToTree\":").append(this.paramsDataToTree);
        sb.append(",\"ignoreRequestParams\":").append(this.ignoreRequestParams);
        sb.append(",\"displayActualType\":").append(this.displayActualType);
        sb.append(",\"responseBodyAdvice\":").append(this.responseBodyAdvice);
        sb.append(",\"style\":\"").append(this.style).append('\"');
        sb.append(",\"createDebugPage\":").append(this.createDebugPage);
        sb.append('}');
        return sb.toString();
    }
}

