/*
 * Decompiled with CFR 0.152.
 */
package com.power.doc.builder;

import com.power.common.util.CollectionUtil;
import com.power.common.util.EnumUtil;
import com.power.common.util.StringUtil;
import com.power.doc.constants.DocLanguage;
import com.power.doc.constants.TemplateVariable;
import com.power.doc.model.ApiConfig;
import com.power.doc.model.ApiErrorCode;
import com.power.doc.model.ApiErrorCodeDictionary;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.beetl.core.Template;

public class BaseDocBuilderTemplate {
    public void checkAndInit(ApiConfig config) {
        this.checkAndInitForGetApiData(config);
        if (StringUtil.isEmpty((String)config.getOutPath())) {
            throw new RuntimeException("doc output path can't be null or empty");
        }
    }

    public void checkAndInitForGetApiData(ApiConfig config) {
        if (null == config) {
            throw new NullPointerException("ApiConfig can't be null");
        }
        if (null != config.getLanguage()) {
            System.setProperty("smart-doc_language", config.getLanguage().getCode());
        } else {
            config.setLanguage(DocLanguage.CHINESE);
            System.setProperty("smart-doc_language", DocLanguage.CHINESE.getCode());
        }
    }

    public Map<String, String> setDirectoryLanguageVariable(ApiConfig config, Template mapper) {
        HashMap<String, String> titleMap = new HashMap<String, String>();
        if (Objects.nonNull((Object)config.getLanguage())) {
            if (DocLanguage.CHINESE.code.equals(config.getLanguage().getCode())) {
                mapper.binding(TemplateVariable.ERROR_LIST_TITLE.getVariable(), (Object)"\u9519\u8bef\u7801\u5217\u8868");
                mapper.binding(TemplateVariable.DICT_LIST_TITLE.getVariable(), (Object)"\u6570\u636e\u5b57\u5178");
                titleMap.put(TemplateVariable.ERROR_LIST_TITLE.getVariable(), "\u9519\u8bef\u7801\u5217\u8868");
                titleMap.put(TemplateVariable.DICT_LIST_TITLE.getVariable(), "\u6570\u636e\u5b57\u5178");
            } else {
                mapper.binding(TemplateVariable.ERROR_LIST_TITLE.getVariable(), (Object)"Error Code List");
                mapper.binding(TemplateVariable.DICT_LIST_TITLE.getVariable(), (Object)"Data Dictionaries");
                titleMap.put(TemplateVariable.ERROR_LIST_TITLE.getVariable(), "Error Code List");
                titleMap.put(TemplateVariable.DICT_LIST_TITLE.getVariable(), "Data Dictionaries");
            }
        } else {
            mapper.binding(TemplateVariable.ERROR_LIST_TITLE.getVariable(), (Object)"\u9519\u8bef\u7801\u5217\u8868");
            mapper.binding(TemplateVariable.DICT_LIST_TITLE.getVariable(), (Object)"\u6570\u636e\u5b57\u5178");
            titleMap.put(TemplateVariable.ERROR_LIST_TITLE.getVariable(), "\u9519\u8bef\u7801\u5217\u8868");
            titleMap.put(TemplateVariable.DICT_LIST_TITLE.getVariable(), "\u6570\u636e\u5b57\u5178");
        }
        return titleMap;
    }

    public List<ApiErrorCode> errorCodeDictToList(ApiConfig config) {
        if (CollectionUtil.isNotEmpty(config.getErrorCodes())) {
            return config.getErrorCodes();
        }
        List<ApiErrorCodeDictionary> errorCodeDictionaries = config.getErrorCodeDictionaries();
        if (CollectionUtil.isEmpty(errorCodeDictionaries)) {
            return new ArrayList<ApiErrorCode>(0);
        }
        ArrayList<ApiErrorCode> errorCodeList = new ArrayList<ApiErrorCode>();
        try {
            for (ApiErrorCodeDictionary dictionary : errorCodeDictionaries) {
                Class<?> clzz = dictionary.getEnumClass();
                if (Objects.isNull(clzz)) {
                    if (StringUtil.isEmpty((String)dictionary.getEnumClassName())) {
                        throw new RuntimeException("Enum class name can't be null.");
                    }
                    clzz = Class.forName(dictionary.getEnumClassName());
                }
                List enumDictionaryList = EnumUtil.getEnumInformation((Class)clzz, (String)dictionary.getCodeField(), (String)dictionary.getDescField());
                errorCodeList.addAll(enumDictionaryList);
            }
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        return errorCodeList;
    }
}

